<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GALKResiliencyRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GALKResiliencyRequest
 * @subpackage Structs
 */
class GALKResiliencyRequest extends ResiliencyRequest
{
    /**
     * The GoldAddressKey
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GoldAddressKey;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * Constructor method for GALKResiliencyRequest
     * @uses GALKResiliencyRequest::setGoldAddressKey()
     * @uses GALKResiliencyRequest::setPostcode()
     * @param string $goldAddressKey
     * @param string $postcode
     */
    public function __construct($goldAddressKey = null, $postcode = null)
    {
        $this
            ->setGoldAddressKey($goldAddressKey)
            ->setPostcode($postcode);
    }
    /**
     * Get GoldAddressKey value
     * @return string|null
     */
    public function getGoldAddressKey()
    {
        return $this->GoldAddressKey;
    }
    /**
     * Set GoldAddressKey value
     * @param string $goldAddressKey
     * @return \StructType\GALKResiliencyRequest
     */
    public function setGoldAddressKey($goldAddressKey = null)
    {
        // validation for constraint: string
        if (!is_null($goldAddressKey) && !is_string($goldAddressKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goldAddressKey)), __LINE__);
        }
        $this->GoldAddressKey = $goldAddressKey;
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\GALKResiliencyRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GALKResiliencyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
