<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GALKAvailabilityRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GALKAvailabilityRequest
 * @subpackage Structs
 */
class GALKAvailabilityRequest extends AvailabilityRequest
{
    /**
     * The CSSDistrictCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CSSDistrictCode;
    /**
     * The GoldAddressKey
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GoldAddressKey;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * Constructor method for GALKAvailabilityRequest
     * @uses GALKAvailabilityRequest::setCSSDistrictCode()
     * @uses GALKAvailabilityRequest::setGoldAddressKey()
     * @uses GALKAvailabilityRequest::setPostcode()
     * @param string $cSSDistrictCode
     * @param string $goldAddressKey
     * @param string $postcode
     */
    public function __construct($cSSDistrictCode = null, $goldAddressKey = null, $postcode = null)
    {
        $this
            ->setCSSDistrictCode($cSSDistrictCode)
            ->setGoldAddressKey($goldAddressKey)
            ->setPostcode($postcode);
    }
    /**
     * Get CSSDistrictCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCSSDistrictCode()
    {
        return isset($this->CSSDistrictCode) ? $this->CSSDistrictCode : null;
    }
    /**
     * Set CSSDistrictCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cSSDistrictCode
     * @return \StructType\GALKAvailabilityRequest
     */
    public function setCSSDistrictCode($cSSDistrictCode = null)
    {
        // validation for constraint: string
        if (!is_null($cSSDistrictCode) && !is_string($cSSDistrictCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cSSDistrictCode)), __LINE__);
        }
        if (is_null($cSSDistrictCode) || (is_array($cSSDistrictCode) && empty($cSSDistrictCode))) {
            unset($this->CSSDistrictCode);
        } else {
            $this->CSSDistrictCode = $cSSDistrictCode;
        }
        return $this;
    }
    /**
     * Get GoldAddressKey value
     * @return string|null
     */
    public function getGoldAddressKey()
    {
        return $this->GoldAddressKey;
    }
    /**
     * Set GoldAddressKey value
     * @param string $goldAddressKey
     * @return \StructType\GALKAvailabilityRequest
     */
    public function setGoldAddressKey($goldAddressKey = null)
    {
        // validation for constraint: string
        if (!is_null($goldAddressKey) && !is_string($goldAddressKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goldAddressKey)), __LINE__);
        }
        $this->GoldAddressKey = $goldAddressKey;
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\GALKAvailabilityRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GALKAvailabilityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
