<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Error
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The ErrorCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCategory;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The InputName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InputName;
    /**
     * The InputValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InputValue;
    /**
     * Constructor method for Error
     * @uses Error::setErrorCategory()
     * @uses Error::setErrorCode()
     * @uses Error::setErrorMessage()
     * @uses Error::setInputName()
     * @uses Error::setInputValue()
     * @param string $errorCategory
     * @param string $errorCode
     * @param string $errorMessage
     * @param string $inputName
     * @param string $inputValue
     */
    public function __construct($errorCategory = null, $errorCode = null, $errorMessage = null, $inputName = null, $inputValue = null)
    {
        $this
            ->setErrorCategory($errorCategory)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setInputName($inputName)
            ->setInputValue($inputValue);
    }
    /**
     * Get ErrorCategory value
     * @return string|null
     */
    public function getErrorCategory()
    {
        return $this->ErrorCategory;
    }
    /**
     * Set ErrorCategory value
     * @uses \EnumType\ErrorCategoryEnum::valueIsValid()
     * @uses \EnumType\ErrorCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCategory
     * @return \StructType\Error
     */
    public function setErrorCategory($errorCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ErrorCategoryEnum::valueIsValid($errorCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorCategory, implode(', ', \EnumType\ErrorCategoryEnum::getValidValues())), __LINE__);
        }
        $this->ErrorCategory = $errorCategory;
        return $this;
    }
    /**
     * Get ErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->ErrorCode) ? $this->ErrorCode : null;
    }
    /**
     * Set ErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \StructType\Error
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->ErrorCode);
        } else {
            $this->ErrorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\Error
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get InputName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInputName()
    {
        return isset($this->InputName) ? $this->InputName : null;
    }
    /**
     * Set InputName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inputName
     * @return \StructType\Error
     */
    public function setInputName($inputName = null)
    {
        // validation for constraint: string
        if (!is_null($inputName) && !is_string($inputName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inputName)), __LINE__);
        }
        if (is_null($inputName) || (is_array($inputName) && empty($inputName))) {
            unset($this->InputName);
        } else {
            $this->InputName = $inputName;
        }
        return $this;
    }
    /**
     * Get InputValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInputValue()
    {
        return isset($this->InputValue) ? $this->InputValue : null;
    }
    /**
     * Set InputValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inputValue
     * @return \StructType\Error
     */
    public function setInputValue($inputValue = null)
    {
        // validation for constraint: string
        if (!is_null($inputValue) && !is_string($inputValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inputValue)), __LINE__);
        }
        if (is_null($inputValue) || (is_array($inputValue) && empty($inputValue))) {
            unset($this->InputValue);
        } else {
            $this->InputValue = $inputValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Error
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
