<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EFMLineLengthType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EFMLineLengthType
 * @subpackage Structs
 */
class EFMLineLengthType extends AbstractStructBase
{
    /**
     * The LengthInMeters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LengthInMeters;
    /**
     * The LineLengthMeasureType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LineLengthMeasureType;
    /**
     * Constructor method for EFMLineLengthType
     * @uses EFMLineLengthType::setLengthInMeters()
     * @uses EFMLineLengthType::setLineLengthMeasureType()
     * @param int $lengthInMeters
     * @param string $lineLengthMeasureType
     */
    public function __construct($lengthInMeters = null, $lineLengthMeasureType = null)
    {
        $this
            ->setLengthInMeters($lengthInMeters)
            ->setLineLengthMeasureType($lineLengthMeasureType);
    }
    /**
     * Get LengthInMeters value
     * @return int|null
     */
    public function getLengthInMeters()
    {
        return $this->LengthInMeters;
    }
    /**
     * Set LengthInMeters value
     * @param int $lengthInMeters
     * @return \StructType\EFMLineLengthType
     */
    public function setLengthInMeters($lengthInMeters = null)
    {
        // validation for constraint: int
        if (!is_null($lengthInMeters) && !is_numeric($lengthInMeters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lengthInMeters)), __LINE__);
        }
        $this->LengthInMeters = $lengthInMeters;
        return $this;
    }
    /**
     * Get LineLengthMeasureType value
     * @return string|null
     */
    public function getLineLengthMeasureType()
    {
        return $this->LineLengthMeasureType;
    }
    /**
     * Set LineLengthMeasureType value
     * @uses \EnumType\EFMLineLengthMeasureType::valueIsValid()
     * @uses \EnumType\EFMLineLengthMeasureType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineLengthMeasureType
     * @return \StructType\EFMLineLengthType
     */
    public function setLineLengthMeasureType($lineLengthMeasureType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EFMLineLengthMeasureType::valueIsValid($lineLengthMeasureType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lineLengthMeasureType, implode(', ', \EnumType\EFMLineLengthMeasureType::getValidValues())), __LINE__);
        }
        $this->LineLengthMeasureType = $lineLengthMeasureType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EFMLineLengthType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
