<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EFMExchangeInfoType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EFMExchangeInfoType
 * @subpackage Structs
 */
class EFMExchangeInfoType extends AbstractStructBase
{
    /**
     * The ExchangeCapacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExchangeCapacityStatusType
     */
    public $ExchangeCapacity;
    /**
     * The ExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeCode;
    /**
     * The ExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeName;
    /**
     * The ResilienceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReslilienceInformationResult
     */
    public $ResilienceInformation;
    /**
     * The TiePairInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TiePairInformationType
     */
    public $TiePairInformation;
    /**
     * Constructor method for EFMExchangeInfoType
     * @uses EFMExchangeInfoType::setExchangeCapacity()
     * @uses EFMExchangeInfoType::setExchangeCode()
     * @uses EFMExchangeInfoType::setExchangeName()
     * @uses EFMExchangeInfoType::setResilienceInformation()
     * @uses EFMExchangeInfoType::setTiePairInformation()
     * @param \StructType\ExchangeCapacityStatusType $exchangeCapacity
     * @param string $exchangeCode
     * @param string $exchangeName
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @param \StructType\TiePairInformationType $tiePairInformation
     */
    public function __construct(\StructType\ExchangeCapacityStatusType $exchangeCapacity = null, $exchangeCode = null, $exchangeName = null, \StructType\ReslilienceInformationResult $resilienceInformation = null, \StructType\TiePairInformationType $tiePairInformation = null)
    {
        $this
            ->setExchangeCapacity($exchangeCapacity)
            ->setExchangeCode($exchangeCode)
            ->setExchangeName($exchangeName)
            ->setResilienceInformation($resilienceInformation)
            ->setTiePairInformation($tiePairInformation);
    }
    /**
     * Get ExchangeCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExchangeCapacityStatusType|null
     */
    public function getExchangeCapacity()
    {
        return isset($this->ExchangeCapacity) ? $this->ExchangeCapacity : null;
    }
    /**
     * Set ExchangeCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExchangeCapacityStatusType $exchangeCapacity
     * @return \StructType\EFMExchangeInfoType
     */
    public function setExchangeCapacity(\StructType\ExchangeCapacityStatusType $exchangeCapacity = null)
    {
        if (is_null($exchangeCapacity) || (is_array($exchangeCapacity) && empty($exchangeCapacity))) {
            unset($this->ExchangeCapacity);
        } else {
            $this->ExchangeCapacity = $exchangeCapacity;
        }
        return $this;
    }
    /**
     * Get ExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeCode()
    {
        return isset($this->ExchangeCode) ? $this->ExchangeCode : null;
    }
    /**
     * Set ExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exchangeCode
     * @return \StructType\EFMExchangeInfoType
     */
    public function setExchangeCode($exchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeCode) && !is_string($exchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeCode)), __LINE__);
        }
        if (is_null($exchangeCode) || (is_array($exchangeCode) && empty($exchangeCode))) {
            unset($this->ExchangeCode);
        } else {
            $this->ExchangeCode = $exchangeCode;
        }
        return $this;
    }
    /**
     * Get ExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeName()
    {
        return isset($this->ExchangeName) ? $this->ExchangeName : null;
    }
    /**
     * Set ExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exchangeName
     * @return \StructType\EFMExchangeInfoType
     */
    public function setExchangeName($exchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeName) && !is_string($exchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeName)), __LINE__);
        }
        if (is_null($exchangeName) || (is_array($exchangeName) && empty($exchangeName))) {
            unset($this->ExchangeName);
        } else {
            $this->ExchangeName = $exchangeName;
        }
        return $this;
    }
    /**
     * Get ResilienceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReslilienceInformationResult|null
     */
    public function getResilienceInformation()
    {
        return isset($this->ResilienceInformation) ? $this->ResilienceInformation : null;
    }
    /**
     * Set ResilienceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @return \StructType\EFMExchangeInfoType
     */
    public function setResilienceInformation(\StructType\ReslilienceInformationResult $resilienceInformation = null)
    {
        if (is_null($resilienceInformation) || (is_array($resilienceInformation) && empty($resilienceInformation))) {
            unset($this->ResilienceInformation);
        } else {
            $this->ResilienceInformation = $resilienceInformation;
        }
        return $this;
    }
    /**
     * Get TiePairInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TiePairInformationType|null
     */
    public function getTiePairInformation()
    {
        return isset($this->TiePairInformation) ? $this->TiePairInformation : null;
    }
    /**
     * Set TiePairInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TiePairInformationType $tiePairInformation
     * @return \StructType\EFMExchangeInfoType
     */
    public function setTiePairInformation(\StructType\TiePairInformationType $tiePairInformation = null)
    {
        if (is_null($tiePairInformation) || (is_array($tiePairInformation) && empty($tiePairInformation))) {
            unset($this->TiePairInformation);
        } else {
            $this->TiePairInformation = $tiePairInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EFMExchangeInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
