<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EFMAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EFMAvailabilityDetails
 * @subpackage Structs
 */
class EFMAvailabilityDetails extends AvailabilityDetails
{
    /**
     * The AccessLineID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLineID;
    /**
     * The AdditionalInformationDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdditionalInformation
     */
    public $AdditionalInformationDetails;
    /**
     * The ExchangeInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEFMExchangeInfoType
     */
    public $ExchangeInfo;
    /**
     * The LineLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EFMLineLengthType
     */
    public $LineLength;
    /**
     * The TiePairBandwidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TiePairBandwidthType
     */
    public $TiePairBandwidth;
    /**
     * The UniqueReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UniqueReference;
    /**
     * Constructor method for EFMAvailabilityDetails
     * @uses EFMAvailabilityDetails::setAccessLineID()
     * @uses EFMAvailabilityDetails::setAdditionalInformationDetails()
     * @uses EFMAvailabilityDetails::setExchangeInfo()
     * @uses EFMAvailabilityDetails::setLineLength()
     * @uses EFMAvailabilityDetails::setTiePairBandwidth()
     * @uses EFMAvailabilityDetails::setUniqueReference()
     * @param string $accessLineID
     * @param \ArrayType\ArrayOfAdditionalInformation $additionalInformationDetails
     * @param \ArrayType\ArrayOfEFMExchangeInfoType $exchangeInfo
     * @param \StructType\EFMLineLengthType $lineLength
     * @param \StructType\TiePairBandwidthType $tiePairBandwidth
     * @param string $uniqueReference
     */
    public function __construct($accessLineID = null, \ArrayType\ArrayOfAdditionalInformation $additionalInformationDetails = null, \ArrayType\ArrayOfEFMExchangeInfoType $exchangeInfo = null, \StructType\EFMLineLengthType $lineLength = null, \StructType\TiePairBandwidthType $tiePairBandwidth = null, $uniqueReference = null)
    {
        $this
            ->setAccessLineID($accessLineID)
            ->setAdditionalInformationDetails($additionalInformationDetails)
            ->setExchangeInfo($exchangeInfo)
            ->setLineLength($lineLength)
            ->setTiePairBandwidth($tiePairBandwidth)
            ->setUniqueReference($uniqueReference);
    }
    /**
     * Get AccessLineID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLineID()
    {
        return isset($this->AccessLineID) ? $this->AccessLineID : null;
    }
    /**
     * Set AccessLineID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLineID
     * @return \StructType\EFMAvailabilityDetails
     */
    public function setAccessLineID($accessLineID = null)
    {
        // validation for constraint: string
        if (!is_null($accessLineID) && !is_string($accessLineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLineID)), __LINE__);
        }
        if (is_null($accessLineID) || (is_array($accessLineID) && empty($accessLineID))) {
            unset($this->AccessLineID);
        } else {
            $this->AccessLineID = $accessLineID;
        }
        return $this;
    }
    /**
     * Get AdditionalInformationDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdditionalInformation|null
     */
    public function getAdditionalInformationDetails()
    {
        return isset($this->AdditionalInformationDetails) ? $this->AdditionalInformationDetails : null;
    }
    /**
     * Set AdditionalInformationDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdditionalInformation $additionalInformationDetails
     * @return \StructType\EFMAvailabilityDetails
     */
    public function setAdditionalInformationDetails(\ArrayType\ArrayOfAdditionalInformation $additionalInformationDetails = null)
    {
        if (is_null($additionalInformationDetails) || (is_array($additionalInformationDetails) && empty($additionalInformationDetails))) {
            unset($this->AdditionalInformationDetails);
        } else {
            $this->AdditionalInformationDetails = $additionalInformationDetails;
        }
        return $this;
    }
    /**
     * Get ExchangeInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEFMExchangeInfoType|null
     */
    public function getExchangeInfo()
    {
        return isset($this->ExchangeInfo) ? $this->ExchangeInfo : null;
    }
    /**
     * Set ExchangeInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEFMExchangeInfoType $exchangeInfo
     * @return \StructType\EFMAvailabilityDetails
     */
    public function setExchangeInfo(\ArrayType\ArrayOfEFMExchangeInfoType $exchangeInfo = null)
    {
        if (is_null($exchangeInfo) || (is_array($exchangeInfo) && empty($exchangeInfo))) {
            unset($this->ExchangeInfo);
        } else {
            $this->ExchangeInfo = $exchangeInfo;
        }
        return $this;
    }
    /**
     * Get LineLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EFMLineLengthType|null
     */
    public function getLineLength()
    {
        return isset($this->LineLength) ? $this->LineLength : null;
    }
    /**
     * Set LineLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EFMLineLengthType $lineLength
     * @return \StructType\EFMAvailabilityDetails
     */
    public function setLineLength(\StructType\EFMLineLengthType $lineLength = null)
    {
        if (is_null($lineLength) || (is_array($lineLength) && empty($lineLength))) {
            unset($this->LineLength);
        } else {
            $this->LineLength = $lineLength;
        }
        return $this;
    }
    /**
     * Get TiePairBandwidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TiePairBandwidthType|null
     */
    public function getTiePairBandwidth()
    {
        return isset($this->TiePairBandwidth) ? $this->TiePairBandwidth : null;
    }
    /**
     * Set TiePairBandwidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TiePairBandwidthType $tiePairBandwidth
     * @return \StructType\EFMAvailabilityDetails
     */
    public function setTiePairBandwidth(\StructType\TiePairBandwidthType $tiePairBandwidth = null)
    {
        if (is_null($tiePairBandwidth) || (is_array($tiePairBandwidth) && empty($tiePairBandwidth))) {
            unset($this->TiePairBandwidth);
        } else {
            $this->TiePairBandwidth = $tiePairBandwidth;
        }
        return $this;
    }
    /**
     * Get UniqueReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUniqueReference()
    {
        return isset($this->UniqueReference) ? $this->UniqueReference : null;
    }
    /**
     * Set UniqueReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uniqueReference
     * @return \StructType\EFMAvailabilityDetails
     */
    public function setUniqueReference($uniqueReference = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueReference) && !is_string($uniqueReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uniqueReference)), __LINE__);
        }
        if (is_null($uniqueReference) || (is_array($uniqueReference) && empty($uniqueReference))) {
            unset($this->UniqueReference);
        } else {
            $this->UniqueReference = $uniqueReference;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EFMAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
