<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DSLType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DSLType
 * @subpackage Structs
 */
class DSLType extends AbstractStructBase
{
    /**
     * The xDSLType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $xDSLType;
    /**
     * Constructor method for DSLType
     * @uses DSLType::setXDSLType()
     * @param string $xDSLType
     */
    public function __construct($xDSLType = null)
    {
        $this
            ->setXDSLType($xDSLType);
    }
    /**
     * Get xDSLType value
     * @return string|null
     */
    public function getXDSLType()
    {
        return $this->xDSLType;
    }
    /**
     * Set xDSLType value
     * @uses \EnumType\XDSLTypeEnum::valueIsValid()
     * @uses \EnumType\XDSLTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $xDSLType
     * @return \StructType\DSLType
     */
    public function setXDSLType($xDSLType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDSLTypeEnum::valueIsValid($xDSLType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $xDSLType, implode(', ', \EnumType\XDSLTypeEnum::getValidValues())), __LINE__);
        }
        $this->xDSLType = $xDSLType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DSLType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
