<?php

namespace EnumType;

/**
 * This class stands for ServiceIncompatibilityEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceIncompatibilityEnum
 * @subpackage Enumerations
 */
class ServiceIncompatibilityEnum
{
    /**
     * Constant for value 'OtherIncompatibleProduct'
     * @return string 'OtherIncompatibleProduct'
     */
    const VALUE_OTHER_INCOMPATIBLE_PRODUCT = 'OtherIncompatibleProduct';
    /**
     * Constant for value 'MultilinePBX'
     * @return string 'MultilinePBX'
     */
    const VALUE_MULTILINE_PBX = 'MultilinePBX';
    /**
     * Constant for value 'RedCareNBLS'
     * @return string 'RedCareNBLS'
     */
    const VALUE_RED_CARE_NBLS = 'RedCareNBLS';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTHER_INCOMPATIBLE_PRODUCT
     * @uses self::VALUE_MULTILINE_PBX
     * @uses self::VALUE_RED_CARE_NBLS
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHER_INCOMPATIBLE_PRODUCT,
            self::VALUE_MULTILINE_PBX,
            self::VALUE_RED_CARE_NBLS,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
