<?php

namespace EnumType;

/**
 * This class stands for ErrorCategoryEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ErrorCategoryEnum
 * @subpackage Enumerations
 */
class ErrorCategoryEnum
{
    /**
     * Constant for value 'SystemError'
     * @return string 'SystemError'
     */
    const VALUE_SYSTEM_ERROR = 'SystemError';
    /**
     * Constant for value 'RequestError'
     * @return string 'RequestError'
     */
    const VALUE_REQUEST_ERROR = 'RequestError';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SYSTEM_ERROR
     * @uses self::VALUE_REQUEST_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SYSTEM_ERROR,
            self::VALUE_REQUEST_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
