<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNGAProductMessage ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNGAProductMessage
 * @subpackage Arrays
 */
class ArrayOfNGAProductMessage extends AbstractStructArrayBase
{
    /**
     * The NGAProductMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NGAProductMessage[]
     */
    public $NGAProductMessage;
    /**
     * Constructor method for ArrayOfNGAProductMessage
     * @uses ArrayOfNGAProductMessage::setNGAProductMessage()
     * @param \StructType\NGAProductMessage[] $nGAProductMessage
     */
    public function __construct(array $nGAProductMessage = array())
    {
        $this
            ->setNGAProductMessage($nGAProductMessage);
    }
    /**
     * Get NGAProductMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NGAProductMessage[]|null
     */
    public function getNGAProductMessage()
    {
        return isset($this->NGAProductMessage) ? $this->NGAProductMessage : null;
    }
    /**
     * Set NGAProductMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NGAProductMessage[] $nGAProductMessage
     * @return \ArrayType\ArrayOfNGAProductMessage
     */
    public function setNGAProductMessage(array $nGAProductMessage = array())
    {
        foreach ($nGAProductMessage as $arrayOfNGAProductMessageNGAProductMessageItem) {
            // validation for constraint: itemType
            if (!$arrayOfNGAProductMessageNGAProductMessageItem instanceof \StructType\NGAProductMessage) {
                throw new \InvalidArgumentException(sprintf('The NGAProductMessage property can only contain items of \StructType\NGAProductMessage, "%s" given', is_object($arrayOfNGAProductMessageNGAProductMessageItem) ? get_class($arrayOfNGAProductMessageNGAProductMessageItem) : gettype($arrayOfNGAProductMessageNGAProductMessageItem)), __LINE__);
            }
        }
        if (is_null($nGAProductMessage) || (is_array($nGAProductMessage) && empty($nGAProductMessage))) {
            unset($this->NGAProductMessage);
        } else {
            $this->NGAProductMessage = $nGAProductMessage;
        }
        return $this;
    }
    /**
     * Add item to NGAProductMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\NGAProductMessage $item
     * @return \ArrayType\ArrayOfNGAProductMessage
     */
    public function addToNGAProductMessage(\StructType\NGAProductMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NGAProductMessage) {
            throw new \InvalidArgumentException(sprintf('The NGAProductMessage property can only contain items of \StructType\NGAProductMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NGAProductMessage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NGAProductMessage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NGAProductMessage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NGAProductMessage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NGAProductMessage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NGAProductMessage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NGAProductMessage
     */
    public function getAttributeName()
    {
        return 'NGAProductMessage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNGAProductMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
