<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLLUExchangeInfo ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLLUExchangeInfo
 * @subpackage Arrays
 */
class ArrayOfLLUExchangeInfo extends AbstractStructArrayBase
{
    /**
     * The LLUExchangeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LLUExchangeInfo[]
     */
    public $LLUExchangeInfo;
    /**
     * Constructor method for ArrayOfLLUExchangeInfo
     * @uses ArrayOfLLUExchangeInfo::setLLUExchangeInfo()
     * @param \StructType\LLUExchangeInfo[] $lLUExchangeInfo
     */
    public function __construct(array $lLUExchangeInfo = array())
    {
        $this
            ->setLLUExchangeInfo($lLUExchangeInfo);
    }
    /**
     * Get LLUExchangeInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LLUExchangeInfo[]|null
     */
    public function getLLUExchangeInfo()
    {
        return isset($this->LLUExchangeInfo) ? $this->LLUExchangeInfo : null;
    }
    /**
     * Set LLUExchangeInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LLUExchangeInfo[] $lLUExchangeInfo
     * @return \ArrayType\ArrayOfLLUExchangeInfo
     */
    public function setLLUExchangeInfo(array $lLUExchangeInfo = array())
    {
        foreach ($lLUExchangeInfo as $arrayOfLLUExchangeInfoLLUExchangeInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfLLUExchangeInfoLLUExchangeInfoItem instanceof \StructType\LLUExchangeInfo) {
                throw new \InvalidArgumentException(sprintf('The LLUExchangeInfo property can only contain items of \StructType\LLUExchangeInfo, "%s" given', is_object($arrayOfLLUExchangeInfoLLUExchangeInfoItem) ? get_class($arrayOfLLUExchangeInfoLLUExchangeInfoItem) : gettype($arrayOfLLUExchangeInfoLLUExchangeInfoItem)), __LINE__);
            }
        }
        if (is_null($lLUExchangeInfo) || (is_array($lLUExchangeInfo) && empty($lLUExchangeInfo))) {
            unset($this->LLUExchangeInfo);
        } else {
            $this->LLUExchangeInfo = $lLUExchangeInfo;
        }
        return $this;
    }
    /**
     * Add item to LLUExchangeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\LLUExchangeInfo $item
     * @return \ArrayType\ArrayOfLLUExchangeInfo
     */
    public function addToLLUExchangeInfo(\StructType\LLUExchangeInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LLUExchangeInfo) {
            throw new \InvalidArgumentException(sprintf('The LLUExchangeInfo property can only contain items of \StructType\LLUExchangeInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LLUExchangeInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LLUExchangeInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LLUExchangeInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LLUExchangeInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LLUExchangeInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LLUExchangeInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LLUExchangeInfo
     */
    public function getAttributeName()
    {
        return 'LLUExchangeInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLLUExchangeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
