<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEDFAAvailability ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEDFAAvailability
 * @subpackage Arrays
 */
class ArrayOfEDFAAvailability extends AbstractStructArrayBase
{
    /**
     * The EDFAAvailability
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EDFAAvailability[]
     */
    public $EDFAAvailability;
    /**
     * Constructor method for ArrayOfEDFAAvailability
     * @uses ArrayOfEDFAAvailability::setEDFAAvailability()
     * @param \StructType\EDFAAvailability[] $eDFAAvailability
     */
    public function __construct(array $eDFAAvailability = array())
    {
        $this
            ->setEDFAAvailability($eDFAAvailability);
    }
    /**
     * Get EDFAAvailability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EDFAAvailability[]|null
     */
    public function getEDFAAvailability()
    {
        return isset($this->EDFAAvailability) ? $this->EDFAAvailability : null;
    }
    /**
     * Set EDFAAvailability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EDFAAvailability[] $eDFAAvailability
     * @return \ArrayType\ArrayOfEDFAAvailability
     */
    public function setEDFAAvailability(array $eDFAAvailability = array())
    {
        foreach ($eDFAAvailability as $arrayOfEDFAAvailabilityEDFAAvailabilityItem) {
            // validation for constraint: itemType
            if (!$arrayOfEDFAAvailabilityEDFAAvailabilityItem instanceof \StructType\EDFAAvailability) {
                throw new \InvalidArgumentException(sprintf('The EDFAAvailability property can only contain items of \StructType\EDFAAvailability, "%s" given', is_object($arrayOfEDFAAvailabilityEDFAAvailabilityItem) ? get_class($arrayOfEDFAAvailabilityEDFAAvailabilityItem) : gettype($arrayOfEDFAAvailabilityEDFAAvailabilityItem)), __LINE__);
            }
        }
        if (is_null($eDFAAvailability) || (is_array($eDFAAvailability) && empty($eDFAAvailability))) {
            unset($this->EDFAAvailability);
        } else {
            $this->EDFAAvailability = $eDFAAvailability;
        }
        return $this;
    }
    /**
     * Add item to EDFAAvailability value
     * @throws \InvalidArgumentException
     * @param \StructType\EDFAAvailability $item
     * @return \ArrayType\ArrayOfEDFAAvailability
     */
    public function addToEDFAAvailability(\StructType\EDFAAvailability $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EDFAAvailability) {
            throw new \InvalidArgumentException(sprintf('The EDFAAvailability property can only contain items of \StructType\EDFAAvailability, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EDFAAvailability[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EDFAAvailability|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EDFAAvailability|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EDFAAvailability|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EDFAAvailability|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EDFAAvailability|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EDFAAvailability
     */
    public function getAttributeName()
    {
        return 'EDFAAvailability';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEDFAAvailability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
