<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPRNAvailabilityRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UPRNAvailabilityRequest
 * @subpackage Structs
 */
class UPRNAvailabilityRequest extends AvailabilityRequest
{
    /**
     * The UPRN
     * @var int
     */
    public $UPRN;
    /**
     * Constructor method for UPRNAvailabilityRequest
     * @uses UPRNAvailabilityRequest::setUPRN()
     * @param int $uPRN
     */
    public function __construct($uPRN = null)
    {
        $this
            ->setUPRN($uPRN);
    }
    /**
     * Get UPRN value
     * @return int|null
     */
    public function getUPRN()
    {
        return $this->UPRN;
    }
    /**
     * Set UPRN value
     * @param int $uPRN
     * @return \StructType\UPRNAvailabilityRequest
     */
    public function setUPRN($uPRN = null)
    {
        // validation for constraint: int
        if (!is_null($uPRN) && !is_numeric($uPRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uPRN)), __LINE__);
        }
        $this->UPRN = $uPRN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UPRNAvailabilityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
