<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoppedLineType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StoppedLineType
 * @subpackage Structs
 */
class StoppedLineType extends AbstractStructBase
{
    /**
     * The InstallationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallationType;
    /**
     * The LastWorkingPartialDN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastWorkingPartialDN;
    /**
     * The OpenOrderDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOpenOrderInfo
     */
    public $OpenOrderDetails;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductType;
    /**
     * The ServiceID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceID;
    /**
     * The StoppedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StoppedDate;
    /**
     * The StoppedLineLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StoppedLineLocation;
    /**
     * The TerminationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminationType;
    /**
     * Constructor method for StoppedLineType
     * @uses StoppedLineType::setInstallationType()
     * @uses StoppedLineType::setLastWorkingPartialDN()
     * @uses StoppedLineType::setOpenOrderDetails()
     * @uses StoppedLineType::setProductType()
     * @uses StoppedLineType::setServiceID()
     * @uses StoppedLineType::setStoppedDate()
     * @uses StoppedLineType::setStoppedLineLocation()
     * @uses StoppedLineType::setTerminationType()
     * @param string $installationType
     * @param string $lastWorkingPartialDN
     * @param \ArrayType\ArrayOfOpenOrderInfo $openOrderDetails
     * @param string $productType
     * @param string $serviceID
     * @param string $stoppedDate
     * @param string $stoppedLineLocation
     * @param string $terminationType
     */
    public function __construct($installationType = null, $lastWorkingPartialDN = null, \ArrayType\ArrayOfOpenOrderInfo $openOrderDetails = null, $productType = null, $serviceID = null, $stoppedDate = null, $stoppedLineLocation = null, $terminationType = null)
    {
        $this
            ->setInstallationType($installationType)
            ->setLastWorkingPartialDN($lastWorkingPartialDN)
            ->setOpenOrderDetails($openOrderDetails)
            ->setProductType($productType)
            ->setServiceID($serviceID)
            ->setStoppedDate($stoppedDate)
            ->setStoppedLineLocation($stoppedLineLocation)
            ->setTerminationType($terminationType);
    }
    /**
     * Get InstallationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallationType()
    {
        return isset($this->InstallationType) ? $this->InstallationType : null;
    }
    /**
     * Set InstallationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installationType
     * @return \StructType\StoppedLineType
     */
    public function setInstallationType($installationType = null)
    {
        // validation for constraint: string
        if (!is_null($installationType) && !is_string($installationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installationType)), __LINE__);
        }
        if (is_null($installationType) || (is_array($installationType) && empty($installationType))) {
            unset($this->InstallationType);
        } else {
            $this->InstallationType = $installationType;
        }
        return $this;
    }
    /**
     * Get LastWorkingPartialDN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastWorkingPartialDN()
    {
        return isset($this->LastWorkingPartialDN) ? $this->LastWorkingPartialDN : null;
    }
    /**
     * Set LastWorkingPartialDN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastWorkingPartialDN
     * @return \StructType\StoppedLineType
     */
    public function setLastWorkingPartialDN($lastWorkingPartialDN = null)
    {
        // validation for constraint: string
        if (!is_null($lastWorkingPartialDN) && !is_string($lastWorkingPartialDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastWorkingPartialDN)), __LINE__);
        }
        if (is_null($lastWorkingPartialDN) || (is_array($lastWorkingPartialDN) && empty($lastWorkingPartialDN))) {
            unset($this->LastWorkingPartialDN);
        } else {
            $this->LastWorkingPartialDN = $lastWorkingPartialDN;
        }
        return $this;
    }
    /**
     * Get OpenOrderDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOpenOrderInfo|null
     */
    public function getOpenOrderDetails()
    {
        return isset($this->OpenOrderDetails) ? $this->OpenOrderDetails : null;
    }
    /**
     * Set OpenOrderDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOpenOrderInfo $openOrderDetails
     * @return \StructType\StoppedLineType
     */
    public function setOpenOrderDetails(\ArrayType\ArrayOfOpenOrderInfo $openOrderDetails = null)
    {
        if (is_null($openOrderDetails) || (is_array($openOrderDetails) && empty($openOrderDetails))) {
            unset($this->OpenOrderDetails);
        } else {
            $this->OpenOrderDetails = $openOrderDetails;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productType
     * @return \StructType\StoppedLineType
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productType)), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get ServiceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceID()
    {
        return isset($this->ServiceID) ? $this->ServiceID : null;
    }
    /**
     * Set ServiceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceID
     * @return \StructType\StoppedLineType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceID)), __LINE__);
        }
        if (is_null($serviceID) || (is_array($serviceID) && empty($serviceID))) {
            unset($this->ServiceID);
        } else {
            $this->ServiceID = $serviceID;
        }
        return $this;
    }
    /**
     * Get StoppedDate value
     * @return string|null
     */
    public function getStoppedDate()
    {
        return $this->StoppedDate;
    }
    /**
     * Set StoppedDate value
     * @param string $stoppedDate
     * @return \StructType\StoppedLineType
     */
    public function setStoppedDate($stoppedDate = null)
    {
        // validation for constraint: string
        if (!is_null($stoppedDate) && !is_string($stoppedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stoppedDate)), __LINE__);
        }
        $this->StoppedDate = $stoppedDate;
        return $this;
    }
    /**
     * Get StoppedLineLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStoppedLineLocation()
    {
        return isset($this->StoppedLineLocation) ? $this->StoppedLineLocation : null;
    }
    /**
     * Set StoppedLineLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stoppedLineLocation
     * @return \StructType\StoppedLineType
     */
    public function setStoppedLineLocation($stoppedLineLocation = null)
    {
        // validation for constraint: string
        if (!is_null($stoppedLineLocation) && !is_string($stoppedLineLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stoppedLineLocation)), __LINE__);
        }
        if (is_null($stoppedLineLocation) || (is_array($stoppedLineLocation) && empty($stoppedLineLocation))) {
            unset($this->StoppedLineLocation);
        } else {
            $this->StoppedLineLocation = $stoppedLineLocation;
        }
        return $this;
    }
    /**
     * Get TerminationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminationType()
    {
        return isset($this->TerminationType) ? $this->TerminationType : null;
    }
    /**
     * Set TerminationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminationType
     * @return \StructType\StoppedLineType
     */
    public function setTerminationType($terminationType = null)
    {
        // validation for constraint: string
        if (!is_null($terminationType) && !is_string($terminationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminationType)), __LINE__);
        }
        if (is_null($terminationType) || (is_array($terminationType) && empty($terminationType))) {
            unset($this->TerminationType);
        } else {
            $this->TerminationType = $terminationType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoppedLineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
