<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceInfo
 * @subpackage Structs
 */
class ServiceInfo extends AbstractStructBase
{
    /**
     * The AccessLineID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLineID;
    /**
     * The AccessLineStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLineStatus;
    /**
     * The AccessLineStatusGfast
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLineStatusGfast;
    /**
     * The AccessLineStatusVDSL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLineStatusVDSL;
    /**
     * The CurrentCP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentCP;
    /**
     * The CurrentReseller
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentReseller;
    /**
     * The CurrentResellerAgentID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CurrentResellerAgentID;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceType;
    /**
     * Constructor method for ServiceInfo
     * @uses ServiceInfo::setAccessLineID()
     * @uses ServiceInfo::setAccessLineStatus()
     * @uses ServiceInfo::setAccessLineStatusGfast()
     * @uses ServiceInfo::setAccessLineStatusVDSL()
     * @uses ServiceInfo::setCurrentCP()
     * @uses ServiceInfo::setCurrentReseller()
     * @uses ServiceInfo::setCurrentResellerAgentID()
     * @uses ServiceInfo::setServiceType()
     * @param string $accessLineID
     * @param string $accessLineStatus
     * @param string $accessLineStatusGfast
     * @param string $accessLineStatusVDSL
     * @param string $currentCP
     * @param string $currentReseller
     * @param int $currentResellerAgentID
     * @param string $serviceType
     */
    public function __construct($accessLineID = null, $accessLineStatus = null, $accessLineStatusGfast = null, $accessLineStatusVDSL = null, $currentCP = null, $currentReseller = null, $currentResellerAgentID = null, $serviceType = null)
    {
        $this
            ->setAccessLineID($accessLineID)
            ->setAccessLineStatus($accessLineStatus)
            ->setAccessLineStatusGfast($accessLineStatusGfast)
            ->setAccessLineStatusVDSL($accessLineStatusVDSL)
            ->setCurrentCP($currentCP)
            ->setCurrentReseller($currentReseller)
            ->setCurrentResellerAgentID($currentResellerAgentID)
            ->setServiceType($serviceType);
    }
    /**
     * Get AccessLineID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLineID()
    {
        return isset($this->AccessLineID) ? $this->AccessLineID : null;
    }
    /**
     * Set AccessLineID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLineID
     * @return \StructType\ServiceInfo
     */
    public function setAccessLineID($accessLineID = null)
    {
        // validation for constraint: string
        if (!is_null($accessLineID) && !is_string($accessLineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLineID)), __LINE__);
        }
        if (is_null($accessLineID) || (is_array($accessLineID) && empty($accessLineID))) {
            unset($this->AccessLineID);
        } else {
            $this->AccessLineID = $accessLineID;
        }
        return $this;
    }
    /**
     * Get AccessLineStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLineStatus()
    {
        return isset($this->AccessLineStatus) ? $this->AccessLineStatus : null;
    }
    /**
     * Set AccessLineStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLineStatus
     * @return \StructType\ServiceInfo
     */
    public function setAccessLineStatus($accessLineStatus = null)
    {
        // validation for constraint: string
        if (!is_null($accessLineStatus) && !is_string($accessLineStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLineStatus)), __LINE__);
        }
        if (is_null($accessLineStatus) || (is_array($accessLineStatus) && empty($accessLineStatus))) {
            unset($this->AccessLineStatus);
        } else {
            $this->AccessLineStatus = $accessLineStatus;
        }
        return $this;
    }
    /**
     * Get AccessLineStatusGfast value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLineStatusGfast()
    {
        return isset($this->AccessLineStatusGfast) ? $this->AccessLineStatusGfast : null;
    }
    /**
     * Set AccessLineStatusGfast value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLineStatusGfast
     * @return \StructType\ServiceInfo
     */
    public function setAccessLineStatusGfast($accessLineStatusGfast = null)
    {
        // validation for constraint: string
        if (!is_null($accessLineStatusGfast) && !is_string($accessLineStatusGfast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLineStatusGfast)), __LINE__);
        }
        if (is_null($accessLineStatusGfast) || (is_array($accessLineStatusGfast) && empty($accessLineStatusGfast))) {
            unset($this->AccessLineStatusGfast);
        } else {
            $this->AccessLineStatusGfast = $accessLineStatusGfast;
        }
        return $this;
    }
    /**
     * Get AccessLineStatusVDSL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLineStatusVDSL()
    {
        return isset($this->AccessLineStatusVDSL) ? $this->AccessLineStatusVDSL : null;
    }
    /**
     * Set AccessLineStatusVDSL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLineStatusVDSL
     * @return \StructType\ServiceInfo
     */
    public function setAccessLineStatusVDSL($accessLineStatusVDSL = null)
    {
        // validation for constraint: string
        if (!is_null($accessLineStatusVDSL) && !is_string($accessLineStatusVDSL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLineStatusVDSL)), __LINE__);
        }
        if (is_null($accessLineStatusVDSL) || (is_array($accessLineStatusVDSL) && empty($accessLineStatusVDSL))) {
            unset($this->AccessLineStatusVDSL);
        } else {
            $this->AccessLineStatusVDSL = $accessLineStatusVDSL;
        }
        return $this;
    }
    /**
     * Get CurrentCP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentCP()
    {
        return isset($this->CurrentCP) ? $this->CurrentCP : null;
    }
    /**
     * Set CurrentCP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentCP
     * @return \StructType\ServiceInfo
     */
    public function setCurrentCP($currentCP = null)
    {
        // validation for constraint: string
        if (!is_null($currentCP) && !is_string($currentCP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentCP)), __LINE__);
        }
        if (is_null($currentCP) || (is_array($currentCP) && empty($currentCP))) {
            unset($this->CurrentCP);
        } else {
            $this->CurrentCP = $currentCP;
        }
        return $this;
    }
    /**
     * Get CurrentReseller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentReseller()
    {
        return isset($this->CurrentReseller) ? $this->CurrentReseller : null;
    }
    /**
     * Set CurrentReseller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentReseller
     * @return \StructType\ServiceInfo
     */
    public function setCurrentReseller($currentReseller = null)
    {
        // validation for constraint: string
        if (!is_null($currentReseller) && !is_string($currentReseller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentReseller)), __LINE__);
        }
        if (is_null($currentReseller) || (is_array($currentReseller) && empty($currentReseller))) {
            unset($this->CurrentReseller);
        } else {
            $this->CurrentReseller = $currentReseller;
        }
        return $this;
    }
    /**
     * Get CurrentResellerAgentID value
     * @return int|null
     */
    public function getCurrentResellerAgentID()
    {
        return $this->CurrentResellerAgentID;
    }
    /**
     * Set CurrentResellerAgentID value
     * @param int $currentResellerAgentID
     * @return \StructType\ServiceInfo
     */
    public function setCurrentResellerAgentID($currentResellerAgentID = null)
    {
        // validation for constraint: int
        if (!is_null($currentResellerAgentID) && !is_numeric($currentResellerAgentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentResellerAgentID)), __LINE__);
        }
        $this->CurrentResellerAgentID = $currentResellerAgentID;
        return $this;
    }
    /**
     * Get ServiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceType()
    {
        return isset($this->ServiceType) ? $this->ServiceType : null;
    }
    /**
     * Set ServiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceType
     * @return \StructType\ServiceInfo
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        if (is_null($serviceType) || (is_array($serviceType) && empty($serviceType))) {
            unset($this->ServiceType);
        } else {
            $this->ServiceType = $serviceType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
