<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrimaryAccessExchangeCircuit StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PrimaryAccessExchangeCircuit
 * @subpackage Structs
 */
class PrimaryAccessExchangeCircuit extends PrimaryAccessIdentifier
{
    /**
     * The ExchangeCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExchangeCode;
    /**
     * The PrimaryAccessCircuitSubType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryAccessCircuitSubType;
    /**
     * The PrimaryAccessCircuitType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PrimaryAccessCircuitType;
    /**
     * Constructor method for PrimaryAccessExchangeCircuit
     * @uses PrimaryAccessExchangeCircuit::setExchangeCode()
     * @uses PrimaryAccessExchangeCircuit::setPrimaryAccessCircuitSubType()
     * @uses PrimaryAccessExchangeCircuit::setPrimaryAccessCircuitType()
     * @param string $exchangeCode
     * @param string $primaryAccessCircuitSubType
     * @param string $primaryAccessCircuitType
     */
    public function __construct($exchangeCode = null, $primaryAccessCircuitSubType = null, $primaryAccessCircuitType = null)
    {
        $this
            ->setExchangeCode($exchangeCode)
            ->setPrimaryAccessCircuitSubType($primaryAccessCircuitSubType)
            ->setPrimaryAccessCircuitType($primaryAccessCircuitType);
    }
    /**
     * Get ExchangeCode value
     * @return string|null
     */
    public function getExchangeCode()
    {
        return $this->ExchangeCode;
    }
    /**
     * Set ExchangeCode value
     * @param string $exchangeCode
     * @return \StructType\PrimaryAccessExchangeCircuit
     */
    public function setExchangeCode($exchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeCode) && !is_string($exchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeCode)), __LINE__);
        }
        $this->ExchangeCode = $exchangeCode;
        return $this;
    }
    /**
     * Get PrimaryAccessCircuitSubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryAccessCircuitSubType()
    {
        return isset($this->PrimaryAccessCircuitSubType) ? $this->PrimaryAccessCircuitSubType : null;
    }
    /**
     * Set PrimaryAccessCircuitSubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryAccessCircuitSubType
     * @return \StructType\PrimaryAccessExchangeCircuit
     */
    public function setPrimaryAccessCircuitSubType($primaryAccessCircuitSubType = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAccessCircuitSubType) && !is_string($primaryAccessCircuitSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAccessCircuitSubType)), __LINE__);
        }
        if (is_null($primaryAccessCircuitSubType) || (is_array($primaryAccessCircuitSubType) && empty($primaryAccessCircuitSubType))) {
            unset($this->PrimaryAccessCircuitSubType);
        } else {
            $this->PrimaryAccessCircuitSubType = $primaryAccessCircuitSubType;
        }
        return $this;
    }
    /**
     * Get PrimaryAccessCircuitType value
     * @return string|null
     */
    public function getPrimaryAccessCircuitType()
    {
        return $this->PrimaryAccessCircuitType;
    }
    /**
     * Set PrimaryAccessCircuitType value
     * @param string $primaryAccessCircuitType
     * @return \StructType\PrimaryAccessExchangeCircuit
     */
    public function setPrimaryAccessCircuitType($primaryAccessCircuitType = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAccessCircuitType) && !is_string($primaryAccessCircuitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAccessCircuitType)), __LINE__);
        }
        $this->PrimaryAccessCircuitType = $primaryAccessCircuitType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrimaryAccessExchangeCircuit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
