<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostcodeResiliencyRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PostcodeResiliencyRequest
 * @subpackage Structs
 */
class PostcodeResiliencyRequest extends ResiliencyRequest
{
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * Constructor method for PostcodeResiliencyRequest
     * @uses PostcodeResiliencyRequest::setPostcode()
     * @param string $postcode
     */
    public function __construct($postcode = null)
    {
        $this
            ->setPostcode($postcode);
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\PostcodeResiliencyRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostcodeResiliencyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
