<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostcodeMatchInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PostcodeMatchInfo
 * @subpackage Structs
 */
class PostcodeMatchInfo extends AbstractStructBase
{
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The PostcodeMatch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostcodeMatch;
    /**
     * Constructor method for PostcodeMatchInfo
     * @uses PostcodeMatchInfo::setPostcode()
     * @uses PostcodeMatchInfo::setPostcodeMatch()
     * @param string $postcode
     * @param string $postcodeMatch
     */
    public function __construct($postcode = null, $postcodeMatch = null)
    {
        $this
            ->setPostcode($postcode)
            ->setPostcodeMatch($postcodeMatch);
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\PostcodeMatchInfo
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get PostcodeMatch value
     * @return string|null
     */
    public function getPostcodeMatch()
    {
        return $this->PostcodeMatch;
    }
    /**
     * Set PostcodeMatch value
     * @uses \EnumType\NotSetYesNoEnum::valueIsValid()
     * @uses \EnumType\NotSetYesNoEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postcodeMatch
     * @return \StructType\PostcodeMatchInfo
     */
    public function setPostcodeMatch($postcodeMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NotSetYesNoEnum::valueIsValid($postcodeMatch)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $postcodeMatch, implode(', ', \EnumType\NotSetYesNoEnum::getValidValues())), __LINE__);
        }
        $this->PostcodeMatch = $postcodeMatch;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostcodeMatchInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
