<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OrdersInformation
 * @subpackage Structs
 */
class OrdersInformation extends AbstractStructBase
{
    /**
     * The OrdersExist
     * @var bool
     */
    public $OrdersExist;
    /**
     * The ViewableOrders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOrderDetails
     */
    public $ViewableOrders;
    /**
     * Constructor method for OrdersInformation
     * @uses OrdersInformation::setOrdersExist()
     * @uses OrdersInformation::setViewableOrders()
     * @param bool $ordersExist
     * @param \ArrayType\ArrayOfOrderDetails $viewableOrders
     */
    public function __construct($ordersExist = null, \ArrayType\ArrayOfOrderDetails $viewableOrders = null)
    {
        $this
            ->setOrdersExist($ordersExist)
            ->setViewableOrders($viewableOrders);
    }
    /**
     * Get OrdersExist value
     * @return bool|null
     */
    public function getOrdersExist()
    {
        return $this->OrdersExist;
    }
    /**
     * Set OrdersExist value
     * @param bool $ordersExist
     * @return \StructType\OrdersInformation
     */
    public function setOrdersExist($ordersExist = null)
    {
        // validation for constraint: boolean
        if (!is_null($ordersExist) && !is_bool($ordersExist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ordersExist)), __LINE__);
        }
        $this->OrdersExist = $ordersExist;
        return $this;
    }
    /**
     * Get ViewableOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOrderDetails|null
     */
    public function getViewableOrders()
    {
        return isset($this->ViewableOrders) ? $this->ViewableOrders : null;
    }
    /**
     * Set ViewableOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOrderDetails $viewableOrders
     * @return \StructType\OrdersInformation
     */
    public function setViewableOrders(\ArrayType\ArrayOfOrderDetails $viewableOrders = null)
    {
        if (is_null($viewableOrders) || (is_array($viewableOrders) && empty($viewableOrders))) {
            unset($this->ViewableOrders);
        } else {
            $this->ViewableOrders = $viewableOrders;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrdersInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
