<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NGAProductMessage StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NGAProductMessage
 * @subpackage Structs
 */
class NGAProductMessage extends AbstractStructBase
{
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductType;
    /**
     * The ProductValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductValue;
    /**
     * Constructor method for NGAProductMessage
     * @uses NGAProductMessage::setProductType()
     * @uses NGAProductMessage::setProductValue()
     * @param string $productType
     * @param string $productValue
     */
    public function __construct($productType = null, $productValue = null)
    {
        $this
            ->setProductType($productType)
            ->setProductValue($productValue);
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productType
     * @return \StructType\NGAProductMessage
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productType)), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get ProductValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductValue()
    {
        return isset($this->ProductValue) ? $this->ProductValue : null;
    }
    /**
     * Set ProductValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productValue
     * @return \StructType\NGAProductMessage
     */
    public function setProductValue($productValue = null)
    {
        // validation for constraint: string
        if (!is_null($productValue) && !is_string($productValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productValue)), __LINE__);
        }
        if (is_null($productValue) || (is_array($productValue) && empty($productValue))) {
            unset($this->ProductValue);
        } else {
            $this->ProductValue = $productValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NGAProductMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
