<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineLengthDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LineLengthDetail
 * @subpackage Structs
 */
class LineLengthDetail extends AbstractStructBase
{
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Length;
    /**
     * The MeasureType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MeasureType;
    /**
     * Constructor method for LineLengthDetail
     * @uses LineLengthDetail::setLength()
     * @uses LineLengthDetail::setMeasureType()
     * @param string $length
     * @param string $measureType
     */
    public function __construct($length = null, $measureType = null)
    {
        $this
            ->setLength($length)
            ->setMeasureType($measureType);
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $length
     * @return \StructType\LineLengthDetail
     */
    public function setLength($length = null)
    {
        // validation for constraint: string
        if (!is_null($length) && !is_string($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($length)), __LINE__);
        }
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
    /**
     * Get MeasureType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMeasureType()
    {
        return isset($this->MeasureType) ? $this->MeasureType : null;
    }
    /**
     * Set MeasureType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $measureType
     * @return \StructType\LineLengthDetail
     */
    public function setMeasureType($measureType = null)
    {
        // validation for constraint: string
        if (!is_null($measureType) && !is_string($measureType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measureType)), __LINE__);
        }
        if (is_null($measureType) || (is_array($measureType) && empty($measureType))) {
            unset($this->MeasureType);
        } else {
            $this->MeasureType = $measureType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LineLengthDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
