<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLUExchangeInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LLUExchangeInfo
 * @subpackage Structs
 */
class LLUExchangeInfo extends AbstractStructBase
{
    /**
     * The CSSExchangeDistrictCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CSSExchangeDistrictCode;
    /**
     * The CircuitLineLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LineLengthDetail
     */
    public $CircuitLineLength;
    /**
     * The ExchangeCapacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeCapacity;
    /**
     * The ExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeCode;
    /**
     * The ExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeName;
    /**
     * The ExchangeState
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeState;
    /**
     * The ForecastDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastDate;
    /**
     * The ProductMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductMessage
     */
    public $ProductMessages;
    /**
     * The ResilienceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReslilienceInformationResult
     */
    public $ResilienceInformation;
    /**
     * Constructor method for LLUExchangeInfo
     * @uses LLUExchangeInfo::setCSSExchangeDistrictCode()
     * @uses LLUExchangeInfo::setCircuitLineLength()
     * @uses LLUExchangeInfo::setExchangeCapacity()
     * @uses LLUExchangeInfo::setExchangeCode()
     * @uses LLUExchangeInfo::setExchangeName()
     * @uses LLUExchangeInfo::setExchangeState()
     * @uses LLUExchangeInfo::setForecastDate()
     * @uses LLUExchangeInfo::setProductMessages()
     * @uses LLUExchangeInfo::setResilienceInformation()
     * @param string $cSSExchangeDistrictCode
     * @param \StructType\LineLengthDetail $circuitLineLength
     * @param string $exchangeCapacity
     * @param string $exchangeCode
     * @param string $exchangeName
     * @param string $exchangeState
     * @param string $forecastDate
     * @param \ArrayType\ArrayOfProductMessage $productMessages
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     */
    public function __construct($cSSExchangeDistrictCode = null, \StructType\LineLengthDetail $circuitLineLength = null, $exchangeCapacity = null, $exchangeCode = null, $exchangeName = null, $exchangeState = null, $forecastDate = null, \ArrayType\ArrayOfProductMessage $productMessages = null, \StructType\ReslilienceInformationResult $resilienceInformation = null)
    {
        $this
            ->setCSSExchangeDistrictCode($cSSExchangeDistrictCode)
            ->setCircuitLineLength($circuitLineLength)
            ->setExchangeCapacity($exchangeCapacity)
            ->setExchangeCode($exchangeCode)
            ->setExchangeName($exchangeName)
            ->setExchangeState($exchangeState)
            ->setForecastDate($forecastDate)
            ->setProductMessages($productMessages)
            ->setResilienceInformation($resilienceInformation);
    }
    /**
     * Get CSSExchangeDistrictCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCSSExchangeDistrictCode()
    {
        return isset($this->CSSExchangeDistrictCode) ? $this->CSSExchangeDistrictCode : null;
    }
    /**
     * Set CSSExchangeDistrictCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cSSExchangeDistrictCode
     * @return \StructType\LLUExchangeInfo
     */
    public function setCSSExchangeDistrictCode($cSSExchangeDistrictCode = null)
    {
        // validation for constraint: string
        if (!is_null($cSSExchangeDistrictCode) && !is_string($cSSExchangeDistrictCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cSSExchangeDistrictCode)), __LINE__);
        }
        if (is_null($cSSExchangeDistrictCode) || (is_array($cSSExchangeDistrictCode) && empty($cSSExchangeDistrictCode))) {
            unset($this->CSSExchangeDistrictCode);
        } else {
            $this->CSSExchangeDistrictCode = $cSSExchangeDistrictCode;
        }
        return $this;
    }
    /**
     * Get CircuitLineLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LineLengthDetail|null
     */
    public function getCircuitLineLength()
    {
        return isset($this->CircuitLineLength) ? $this->CircuitLineLength : null;
    }
    /**
     * Set CircuitLineLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LineLengthDetail $circuitLineLength
     * @return \StructType\LLUExchangeInfo
     */
    public function setCircuitLineLength(\StructType\LineLengthDetail $circuitLineLength = null)
    {
        if (is_null($circuitLineLength) || (is_array($circuitLineLength) && empty($circuitLineLength))) {
            unset($this->CircuitLineLength);
        } else {
            $this->CircuitLineLength = $circuitLineLength;
        }
        return $this;
    }
    /**
     * Get ExchangeCapacity value
     * @return string|null
     */
    public function getExchangeCapacity()
    {
        return $this->ExchangeCapacity;
    }
    /**
     * Set ExchangeCapacity value
     * @uses \EnumType\LLUExchangeCapacityEnum::valueIsValid()
     * @uses \EnumType\LLUExchangeCapacityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exchangeCapacity
     * @return \StructType\LLUExchangeInfo
     */
    public function setExchangeCapacity($exchangeCapacity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LLUExchangeCapacityEnum::valueIsValid($exchangeCapacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $exchangeCapacity, implode(', ', \EnumType\LLUExchangeCapacityEnum::getValidValues())), __LINE__);
        }
        $this->ExchangeCapacity = $exchangeCapacity;
        return $this;
    }
    /**
     * Get ExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeCode()
    {
        return isset($this->ExchangeCode) ? $this->ExchangeCode : null;
    }
    /**
     * Set ExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exchangeCode
     * @return \StructType\LLUExchangeInfo
     */
    public function setExchangeCode($exchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeCode) && !is_string($exchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeCode)), __LINE__);
        }
        if (is_null($exchangeCode) || (is_array($exchangeCode) && empty($exchangeCode))) {
            unset($this->ExchangeCode);
        } else {
            $this->ExchangeCode = $exchangeCode;
        }
        return $this;
    }
    /**
     * Get ExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeName()
    {
        return isset($this->ExchangeName) ? $this->ExchangeName : null;
    }
    /**
     * Set ExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exchangeName
     * @return \StructType\LLUExchangeInfo
     */
    public function setExchangeName($exchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeName) && !is_string($exchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeName)), __LINE__);
        }
        if (is_null($exchangeName) || (is_array($exchangeName) && empty($exchangeName))) {
            unset($this->ExchangeName);
        } else {
            $this->ExchangeName = $exchangeName;
        }
        return $this;
    }
    /**
     * Get ExchangeState value
     * @return string|null
     */
    public function getExchangeState()
    {
        return $this->ExchangeState;
    }
    /**
     * Set ExchangeState value
     * @uses \EnumType\LLUExchangeStateEnum::valueIsValid()
     * @uses \EnumType\LLUExchangeStateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exchangeState
     * @return \StructType\LLUExchangeInfo
     */
    public function setExchangeState($exchangeState = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LLUExchangeStateEnum::valueIsValid($exchangeState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $exchangeState, implode(', ', \EnumType\LLUExchangeStateEnum::getValidValues())), __LINE__);
        }
        $this->ExchangeState = $exchangeState;
        return $this;
    }
    /**
     * Get ForecastDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastDate()
    {
        return isset($this->ForecastDate) ? $this->ForecastDate : null;
    }
    /**
     * Set ForecastDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastDate
     * @return \StructType\LLUExchangeInfo
     */
    public function setForecastDate($forecastDate = null)
    {
        // validation for constraint: string
        if (!is_null($forecastDate) && !is_string($forecastDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forecastDate)), __LINE__);
        }
        if (is_null($forecastDate) || (is_array($forecastDate) && empty($forecastDate))) {
            unset($this->ForecastDate);
        } else {
            $this->ForecastDate = $forecastDate;
        }
        return $this;
    }
    /**
     * Get ProductMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductMessage|null
     */
    public function getProductMessages()
    {
        return isset($this->ProductMessages) ? $this->ProductMessages : null;
    }
    /**
     * Set ProductMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductMessage $productMessages
     * @return \StructType\LLUExchangeInfo
     */
    public function setProductMessages(\ArrayType\ArrayOfProductMessage $productMessages = null)
    {
        if (is_null($productMessages) || (is_array($productMessages) && empty($productMessages))) {
            unset($this->ProductMessages);
        } else {
            $this->ProductMessages = $productMessages;
        }
        return $this;
    }
    /**
     * Get ResilienceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReslilienceInformationResult|null
     */
    public function getResilienceInformation()
    {
        return isset($this->ResilienceInformation) ? $this->ResilienceInformation : null;
    }
    /**
     * Set ResilienceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @return \StructType\LLUExchangeInfo
     */
    public function setResilienceInformation(\StructType\ReslilienceInformationResult $resilienceInformation = null)
    {
        if (is_null($resilienceInformation) || (is_array($resilienceInformation) && empty($resilienceInformation))) {
            unset($this->ResilienceInformation);
        } else {
            $this->ResilienceInformation = $resilienceInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LLUExchangeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
