<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FutureResilience StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FutureResilience
 * @subpackage Structs
 */
class FutureResilience extends AbstractStructBase
{
    /**
     * The FutureResilientLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FutureResilientLevel;
    /**
     * The PrimaryExchangeRFSDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryExchangeRFSDate;
    /**
     * The PrimaryProviderEdgeExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryProviderEdgeExchangeCode;
    /**
     * The PrimaryProviderEdgeExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryProviderEdgeExchangeName;
    /**
     * The SecondaryExchangeRFSDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SecondaryExchangeRFSDate;
    /**
     * The SecondaryProviderEdgeExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondaryProviderEdgeExchangeCode;
    /**
     * The SecondaryProviderEdgeExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondaryProviderEdgeExchangeName;
    /**
     * Constructor method for FutureResilience
     * @uses FutureResilience::setFutureResilientLevel()
     * @uses FutureResilience::setPrimaryExchangeRFSDate()
     * @uses FutureResilience::setPrimaryProviderEdgeExchangeCode()
     * @uses FutureResilience::setPrimaryProviderEdgeExchangeName()
     * @uses FutureResilience::setSecondaryExchangeRFSDate()
     * @uses FutureResilience::setSecondaryProviderEdgeExchangeCode()
     * @uses FutureResilience::setSecondaryProviderEdgeExchangeName()
     * @param string $futureResilientLevel
     * @param string $primaryExchangeRFSDate
     * @param string $primaryProviderEdgeExchangeCode
     * @param string $primaryProviderEdgeExchangeName
     * @param string $secondaryExchangeRFSDate
     * @param string $secondaryProviderEdgeExchangeCode
     * @param string $secondaryProviderEdgeExchangeName
     */
    public function __construct($futureResilientLevel = null, $primaryExchangeRFSDate = null, $primaryProviderEdgeExchangeCode = null, $primaryProviderEdgeExchangeName = null, $secondaryExchangeRFSDate = null, $secondaryProviderEdgeExchangeCode = null, $secondaryProviderEdgeExchangeName = null)
    {
        $this
            ->setFutureResilientLevel($futureResilientLevel)
            ->setPrimaryExchangeRFSDate($primaryExchangeRFSDate)
            ->setPrimaryProviderEdgeExchangeCode($primaryProviderEdgeExchangeCode)
            ->setPrimaryProviderEdgeExchangeName($primaryProviderEdgeExchangeName)
            ->setSecondaryExchangeRFSDate($secondaryExchangeRFSDate)
            ->setSecondaryProviderEdgeExchangeCode($secondaryProviderEdgeExchangeCode)
            ->setSecondaryProviderEdgeExchangeName($secondaryProviderEdgeExchangeName);
    }
    /**
     * Get FutureResilientLevel value
     * @return string|null
     */
    public function getFutureResilientLevel()
    {
        return $this->FutureResilientLevel;
    }
    /**
     * Set FutureResilientLevel value
     * @uses \EnumType\FutureResilienceLevelEnum::valueIsValid()
     * @uses \EnumType\FutureResilienceLevelEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $futureResilientLevel
     * @return \StructType\FutureResilience
     */
    public function setFutureResilientLevel($futureResilientLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FutureResilienceLevelEnum::valueIsValid($futureResilientLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $futureResilientLevel, implode(', ', \EnumType\FutureResilienceLevelEnum::getValidValues())), __LINE__);
        }
        $this->FutureResilientLevel = $futureResilientLevel;
        return $this;
    }
    /**
     * Get PrimaryExchangeRFSDate value
     * @return string|null
     */
    public function getPrimaryExchangeRFSDate()
    {
        return $this->PrimaryExchangeRFSDate;
    }
    /**
     * Set PrimaryExchangeRFSDate value
     * @param string $primaryExchangeRFSDate
     * @return \StructType\FutureResilience
     */
    public function setPrimaryExchangeRFSDate($primaryExchangeRFSDate = null)
    {
        // validation for constraint: string
        if (!is_null($primaryExchangeRFSDate) && !is_string($primaryExchangeRFSDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryExchangeRFSDate)), __LINE__);
        }
        $this->PrimaryExchangeRFSDate = $primaryExchangeRFSDate;
        return $this;
    }
    /**
     * Get PrimaryProviderEdgeExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryProviderEdgeExchangeCode()
    {
        return isset($this->PrimaryProviderEdgeExchangeCode) ? $this->PrimaryProviderEdgeExchangeCode : null;
    }
    /**
     * Set PrimaryProviderEdgeExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryProviderEdgeExchangeCode
     * @return \StructType\FutureResilience
     */
    public function setPrimaryProviderEdgeExchangeCode($primaryProviderEdgeExchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($primaryProviderEdgeExchangeCode) && !is_string($primaryProviderEdgeExchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryProviderEdgeExchangeCode)), __LINE__);
        }
        if (is_null($primaryProviderEdgeExchangeCode) || (is_array($primaryProviderEdgeExchangeCode) && empty($primaryProviderEdgeExchangeCode))) {
            unset($this->PrimaryProviderEdgeExchangeCode);
        } else {
            $this->PrimaryProviderEdgeExchangeCode = $primaryProviderEdgeExchangeCode;
        }
        return $this;
    }
    /**
     * Get PrimaryProviderEdgeExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryProviderEdgeExchangeName()
    {
        return isset($this->PrimaryProviderEdgeExchangeName) ? $this->PrimaryProviderEdgeExchangeName : null;
    }
    /**
     * Set PrimaryProviderEdgeExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryProviderEdgeExchangeName
     * @return \StructType\FutureResilience
     */
    public function setPrimaryProviderEdgeExchangeName($primaryProviderEdgeExchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($primaryProviderEdgeExchangeName) && !is_string($primaryProviderEdgeExchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryProviderEdgeExchangeName)), __LINE__);
        }
        if (is_null($primaryProviderEdgeExchangeName) || (is_array($primaryProviderEdgeExchangeName) && empty($primaryProviderEdgeExchangeName))) {
            unset($this->PrimaryProviderEdgeExchangeName);
        } else {
            $this->PrimaryProviderEdgeExchangeName = $primaryProviderEdgeExchangeName;
        }
        return $this;
    }
    /**
     * Get SecondaryExchangeRFSDate value
     * @return string|null
     */
    public function getSecondaryExchangeRFSDate()
    {
        return $this->SecondaryExchangeRFSDate;
    }
    /**
     * Set SecondaryExchangeRFSDate value
     * @param string $secondaryExchangeRFSDate
     * @return \StructType\FutureResilience
     */
    public function setSecondaryExchangeRFSDate($secondaryExchangeRFSDate = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryExchangeRFSDate) && !is_string($secondaryExchangeRFSDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryExchangeRFSDate)), __LINE__);
        }
        $this->SecondaryExchangeRFSDate = $secondaryExchangeRFSDate;
        return $this;
    }
    /**
     * Get SecondaryProviderEdgeExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryProviderEdgeExchangeCode()
    {
        return isset($this->SecondaryProviderEdgeExchangeCode) ? $this->SecondaryProviderEdgeExchangeCode : null;
    }
    /**
     * Set SecondaryProviderEdgeExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryProviderEdgeExchangeCode
     * @return \StructType\FutureResilience
     */
    public function setSecondaryProviderEdgeExchangeCode($secondaryProviderEdgeExchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryProviderEdgeExchangeCode) && !is_string($secondaryProviderEdgeExchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryProviderEdgeExchangeCode)), __LINE__);
        }
        if (is_null($secondaryProviderEdgeExchangeCode) || (is_array($secondaryProviderEdgeExchangeCode) && empty($secondaryProviderEdgeExchangeCode))) {
            unset($this->SecondaryProviderEdgeExchangeCode);
        } else {
            $this->SecondaryProviderEdgeExchangeCode = $secondaryProviderEdgeExchangeCode;
        }
        return $this;
    }
    /**
     * Get SecondaryProviderEdgeExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryProviderEdgeExchangeName()
    {
        return isset($this->SecondaryProviderEdgeExchangeName) ? $this->SecondaryProviderEdgeExchangeName : null;
    }
    /**
     * Set SecondaryProviderEdgeExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryProviderEdgeExchangeName
     * @return \StructType\FutureResilience
     */
    public function setSecondaryProviderEdgeExchangeName($secondaryProviderEdgeExchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryProviderEdgeExchangeName) && !is_string($secondaryProviderEdgeExchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryProviderEdgeExchangeName)), __LINE__);
        }
        if (is_null($secondaryProviderEdgeExchangeName) || (is_array($secondaryProviderEdgeExchangeName) && empty($secondaryProviderEdgeExchangeName))) {
            unset($this->SecondaryProviderEdgeExchangeName);
        } else {
            $this->SecondaryProviderEdgeExchangeName = $secondaryProviderEdgeExchangeName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FutureResilience
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
