<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EDFAAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EDFAAvailabilityDetails
 * @subpackage Structs
 */
class EDFAAvailabilityDetails extends AvailabilityDetails
{
    /**
     * The EDFAAvailability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEDFAAvailability
     */
    public $EDFAAvailability;
    /**
     * The GoldAddressKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GoldAddressKey;
    /**
     * The NonGoldAddressKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NonGoldAddressKey;
    /**
     * The PostCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostCode;
    /**
     * Constructor method for EDFAAvailabilityDetails
     * @uses EDFAAvailabilityDetails::setEDFAAvailability()
     * @uses EDFAAvailabilityDetails::setGoldAddressKey()
     * @uses EDFAAvailabilityDetails::setNonGoldAddressKey()
     * @uses EDFAAvailabilityDetails::setPostCode()
     * @param \ArrayType\ArrayOfEDFAAvailability $eDFAAvailability
     * @param string $goldAddressKey
     * @param string $nonGoldAddressKey
     * @param string $postCode
     */
    public function __construct(\ArrayType\ArrayOfEDFAAvailability $eDFAAvailability = null, $goldAddressKey = null, $nonGoldAddressKey = null, $postCode = null)
    {
        $this
            ->setEDFAAvailability($eDFAAvailability)
            ->setGoldAddressKey($goldAddressKey)
            ->setNonGoldAddressKey($nonGoldAddressKey)
            ->setPostCode($postCode);
    }
    /**
     * Get EDFAAvailability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEDFAAvailability|null
     */
    public function getEDFAAvailability()
    {
        return isset($this->EDFAAvailability) ? $this->EDFAAvailability : null;
    }
    /**
     * Set EDFAAvailability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEDFAAvailability $eDFAAvailability
     * @return \StructType\EDFAAvailabilityDetails
     */
    public function setEDFAAvailability(\ArrayType\ArrayOfEDFAAvailability $eDFAAvailability = null)
    {
        if (is_null($eDFAAvailability) || (is_array($eDFAAvailability) && empty($eDFAAvailability))) {
            unset($this->EDFAAvailability);
        } else {
            $this->EDFAAvailability = $eDFAAvailability;
        }
        return $this;
    }
    /**
     * Get GoldAddressKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGoldAddressKey()
    {
        return isset($this->GoldAddressKey) ? $this->GoldAddressKey : null;
    }
    /**
     * Set GoldAddressKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $goldAddressKey
     * @return \StructType\EDFAAvailabilityDetails
     */
    public function setGoldAddressKey($goldAddressKey = null)
    {
        // validation for constraint: string
        if (!is_null($goldAddressKey) && !is_string($goldAddressKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goldAddressKey)), __LINE__);
        }
        if (is_null($goldAddressKey) || (is_array($goldAddressKey) && empty($goldAddressKey))) {
            unset($this->GoldAddressKey);
        } else {
            $this->GoldAddressKey = $goldAddressKey;
        }
        return $this;
    }
    /**
     * Get NonGoldAddressKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNonGoldAddressKey()
    {
        return isset($this->NonGoldAddressKey) ? $this->NonGoldAddressKey : null;
    }
    /**
     * Set NonGoldAddressKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nonGoldAddressKey
     * @return \StructType\EDFAAvailabilityDetails
     */
    public function setNonGoldAddressKey($nonGoldAddressKey = null)
    {
        // validation for constraint: string
        if (!is_null($nonGoldAddressKey) && !is_string($nonGoldAddressKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nonGoldAddressKey)), __LINE__);
        }
        if (is_null($nonGoldAddressKey) || (is_array($nonGoldAddressKey) && empty($nonGoldAddressKey))) {
            unset($this->NonGoldAddressKey);
        } else {
            $this->NonGoldAddressKey = $nonGoldAddressKey;
        }
        return $this;
    }
    /**
     * Get PostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostCode()
    {
        return isset($this->PostCode) ? $this->PostCode : null;
    }
    /**
     * Set PostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postCode
     * @return \StructType\EDFAAvailabilityDetails
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        if (is_null($postCode) || (is_array($postCode) && empty($postCode))) {
            unset($this->PostCode);
        } else {
            $this->PostCode = $postCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EDFAAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
