<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressAvailabilityRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressAvailabilityRequest
 * @subpackage Structs
 */
class AddressAvailabilityRequest extends AvailabilityRequest
{
    /**
     * The BuildingName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuildingName;
    /**
     * The BuildingNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuildingNumber;
    /**
     * The DependentThoroughfare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DependentThoroughfare;
    /**
     * The Locality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Locality;
    /**
     * The OrganisationName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganisationName;
    /**
     * The PostTown
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostTown;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Street;
    /**
     * The SubBuilding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubBuilding;
    /**
     * Constructor method for AddressAvailabilityRequest
     * @uses AddressAvailabilityRequest::setBuildingName()
     * @uses AddressAvailabilityRequest::setBuildingNumber()
     * @uses AddressAvailabilityRequest::setDependentThoroughfare()
     * @uses AddressAvailabilityRequest::setLocality()
     * @uses AddressAvailabilityRequest::setOrganisationName()
     * @uses AddressAvailabilityRequest::setPostTown()
     * @uses AddressAvailabilityRequest::setPostcode()
     * @uses AddressAvailabilityRequest::setStreet()
     * @uses AddressAvailabilityRequest::setSubBuilding()
     * @param string $buildingName
     * @param string $buildingNumber
     * @param string $dependentThoroughfare
     * @param string $locality
     * @param string $organisationName
     * @param string $postTown
     * @param string $postcode
     * @param string $street
     * @param string $subBuilding
     */
    public function __construct($buildingName = null, $buildingNumber = null, $dependentThoroughfare = null, $locality = null, $organisationName = null, $postTown = null, $postcode = null, $street = null, $subBuilding = null)
    {
        $this
            ->setBuildingName($buildingName)
            ->setBuildingNumber($buildingNumber)
            ->setDependentThoroughfare($dependentThoroughfare)
            ->setLocality($locality)
            ->setOrganisationName($organisationName)
            ->setPostTown($postTown)
            ->setPostcode($postcode)
            ->setStreet($street)
            ->setSubBuilding($subBuilding);
    }
    /**
     * Get BuildingName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuildingName()
    {
        return isset($this->BuildingName) ? $this->BuildingName : null;
    }
    /**
     * Set BuildingName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buildingName
     * @return \StructType\AddressAvailabilityRequest
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buildingName)), __LINE__);
        }
        if (is_null($buildingName) || (is_array($buildingName) && empty($buildingName))) {
            unset($this->BuildingName);
        } else {
            $this->BuildingName = $buildingName;
        }
        return $this;
    }
    /**
     * Get BuildingNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuildingNumber()
    {
        return isset($this->BuildingNumber) ? $this->BuildingNumber : null;
    }
    /**
     * Set BuildingNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buildingNumber
     * @return \StructType\AddressAvailabilityRequest
     */
    public function setBuildingNumber($buildingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNumber) && !is_string($buildingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buildingNumber)), __LINE__);
        }
        if (is_null($buildingNumber) || (is_array($buildingNumber) && empty($buildingNumber))) {
            unset($this->BuildingNumber);
        } else {
            $this->BuildingNumber = $buildingNumber;
        }
        return $this;
    }
    /**
     * Get DependentThoroughfare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDependentThoroughfare()
    {
        return isset($this->DependentThoroughfare) ? $this->DependentThoroughfare : null;
    }
    /**
     * Set DependentThoroughfare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dependentThoroughfare
     * @return \StructType\AddressAvailabilityRequest
     */
    public function setDependentThoroughfare($dependentThoroughfare = null)
    {
        // validation for constraint: string
        if (!is_null($dependentThoroughfare) && !is_string($dependentThoroughfare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dependentThoroughfare)), __LINE__);
        }
        if (is_null($dependentThoroughfare) || (is_array($dependentThoroughfare) && empty($dependentThoroughfare))) {
            unset($this->DependentThoroughfare);
        } else {
            $this->DependentThoroughfare = $dependentThoroughfare;
        }
        return $this;
    }
    /**
     * Get Locality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocality()
    {
        return isset($this->Locality) ? $this->Locality : null;
    }
    /**
     * Set Locality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locality
     * @return \StructType\AddressAvailabilityRequest
     */
    public function setLocality($locality = null)
    {
        // validation for constraint: string
        if (!is_null($locality) && !is_string($locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locality)), __LINE__);
        }
        if (is_null($locality) || (is_array($locality) && empty($locality))) {
            unset($this->Locality);
        } else {
            $this->Locality = $locality;
        }
        return $this;
    }
    /**
     * Get OrganisationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganisationName()
    {
        return isset($this->OrganisationName) ? $this->OrganisationName : null;
    }
    /**
     * Set OrganisationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organisationName
     * @return \StructType\AddressAvailabilityRequest
     */
    public function setOrganisationName($organisationName = null)
    {
        // validation for constraint: string
        if (!is_null($organisationName) && !is_string($organisationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationName)), __LINE__);
        }
        if (is_null($organisationName) || (is_array($organisationName) && empty($organisationName))) {
            unset($this->OrganisationName);
        } else {
            $this->OrganisationName = $organisationName;
        }
        return $this;
    }
    /**
     * Get PostTown value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostTown()
    {
        return isset($this->PostTown) ? $this->PostTown : null;
    }
    /**
     * Set PostTown value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postTown
     * @return \StructType\AddressAvailabilityRequest
     */
    public function setPostTown($postTown = null)
    {
        // validation for constraint: string
        if (!is_null($postTown) && !is_string($postTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postTown)), __LINE__);
        }
        if (is_null($postTown) || (is_array($postTown) && empty($postTown))) {
            unset($this->PostTown);
        } else {
            $this->PostTown = $postTown;
        }
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\AddressAvailabilityRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get Street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->Street) ? $this->Street : null;
    }
    /**
     * Set Street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \StructType\AddressAvailabilityRequest
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->Street);
        } else {
            $this->Street = $street;
        }
        return $this;
    }
    /**
     * Get SubBuilding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubBuilding()
    {
        return isset($this->SubBuilding) ? $this->SubBuilding : null;
    }
    /**
     * Set SubBuilding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subBuilding
     * @return \StructType\AddressAvailabilityRequest
     */
    public function setSubBuilding($subBuilding = null)
    {
        // validation for constraint: string
        if (!is_null($subBuilding) && !is_string($subBuilding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subBuilding)), __LINE__);
        }
        if (is_null($subBuilding) || (is_array($subBuilding) && empty($subBuilding))) {
            unset($this->SubBuilding);
        } else {
            $this->SubBuilding = $subBuilding;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressAvailabilityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
