<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalMessagesDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AdditionalMessagesDetails
 * @subpackage Structs
 */
class AdditionalMessagesDetails extends AbstractStructBase
{
    /**
     * The SuggestedMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SuggestedMessage;
    /**
     * The SupplementaryMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupplementaryMessage;
    /**
     * Constructor method for AdditionalMessagesDetails
     * @uses AdditionalMessagesDetails::setSuggestedMessage()
     * @uses AdditionalMessagesDetails::setSupplementaryMessage()
     * @param string $suggestedMessage
     * @param string $supplementaryMessage
     */
    public function __construct($suggestedMessage = null, $supplementaryMessage = null)
    {
        $this
            ->setSuggestedMessage($suggestedMessage)
            ->setSupplementaryMessage($supplementaryMessage);
    }
    /**
     * Get SuggestedMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuggestedMessage()
    {
        return isset($this->SuggestedMessage) ? $this->SuggestedMessage : null;
    }
    /**
     * Set SuggestedMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suggestedMessage
     * @return \StructType\AdditionalMessagesDetails
     */
    public function setSuggestedMessage($suggestedMessage = null)
    {
        // validation for constraint: string
        if (!is_null($suggestedMessage) && !is_string($suggestedMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suggestedMessage)), __LINE__);
        }
        if (is_null($suggestedMessage) || (is_array($suggestedMessage) && empty($suggestedMessage))) {
            unset($this->SuggestedMessage);
        } else {
            $this->SuggestedMessage = $suggestedMessage;
        }
        return $this;
    }
    /**
     * Get SupplementaryMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplementaryMessage()
    {
        return isset($this->SupplementaryMessage) ? $this->SupplementaryMessage : null;
    }
    /**
     * Set SupplementaryMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplementaryMessage
     * @return \StructType\AdditionalMessagesDetails
     */
    public function setSupplementaryMessage($supplementaryMessage = null)
    {
        // validation for constraint: string
        if (!is_null($supplementaryMessage) && !is_string($supplementaryMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplementaryMessage)), __LINE__);
        }
        if (is_null($supplementaryMessage) || (is_array($supplementaryMessage) && empty($supplementaryMessage))) {
            unset($this->SupplementaryMessage);
        } else {
            $this->SupplementaryMessage = $supplementaryMessage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalMessagesDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
