<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ADSLAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ADSLAvailabilityDetails
 * @subpackage Structs
 */
class ADSLAvailabilityDetails extends AbstractStructBase
{
    /**
     * The EstimatedDownstreamSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedDownstreamSpeed;
    /**
     * The EstimatedMaxRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedMaxRange;
    /**
     * The EstimatedMinRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedMinRange;
    /**
     * The EstimatedThroughputSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfThroughputSpeedType
     */
    public $EstimatedThroughputSpeed;
    /**
     * The FixedRateCapacityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FixedRateCapacityDate;
    /**
     * The FixedRateExchangeStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FixedRateExchangeStatus;
    /**
     * The FixedRateLineStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FixedRateLineStatus;
    /**
     * The FixedRateReadyDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FixedRateReadyDate;
    /**
     * The MaxAvailable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MaxAvailable;
    /**
     * The MaxCapacityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MaxCapacityDate;
    /**
     * The MaxExchangeStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MaxExchangeStatus;
    /**
     * The MaxReadyDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MaxReadyDate;
    /**
     * The MinThreshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinThreshold;
    /**
     * Constructor method for ADSLAvailabilityDetails
     * @uses ADSLAvailabilityDetails::setEstimatedDownstreamSpeed()
     * @uses ADSLAvailabilityDetails::setEstimatedMaxRange()
     * @uses ADSLAvailabilityDetails::setEstimatedMinRange()
     * @uses ADSLAvailabilityDetails::setEstimatedThroughputSpeed()
     * @uses ADSLAvailabilityDetails::setFixedRateCapacityDate()
     * @uses ADSLAvailabilityDetails::setFixedRateExchangeStatus()
     * @uses ADSLAvailabilityDetails::setFixedRateLineStatus()
     * @uses ADSLAvailabilityDetails::setFixedRateReadyDate()
     * @uses ADSLAvailabilityDetails::setMaxAvailable()
     * @uses ADSLAvailabilityDetails::setMaxCapacityDate()
     * @uses ADSLAvailabilityDetails::setMaxExchangeStatus()
     * @uses ADSLAvailabilityDetails::setMaxReadyDate()
     * @uses ADSLAvailabilityDetails::setMinThreshold()
     * @param string $estimatedDownstreamSpeed
     * @param string $estimatedMaxRange
     * @param string $estimatedMinRange
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed
     * @param string $fixedRateCapacityDate
     * @param string $fixedRateExchangeStatus
     * @param int $fixedRateLineStatus
     * @param string $fixedRateReadyDate
     * @param string $maxAvailable
     * @param string $maxCapacityDate
     * @param string $maxExchangeStatus
     * @param string $maxReadyDate
     * @param string $minThreshold
     */
    public function __construct($estimatedDownstreamSpeed = null, $estimatedMaxRange = null, $estimatedMinRange = null, \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed = null, $fixedRateCapacityDate = null, $fixedRateExchangeStatus = null, $fixedRateLineStatus = null, $fixedRateReadyDate = null, $maxAvailable = null, $maxCapacityDate = null, $maxExchangeStatus = null, $maxReadyDate = null, $minThreshold = null)
    {
        $this
            ->setEstimatedDownstreamSpeed($estimatedDownstreamSpeed)
            ->setEstimatedMaxRange($estimatedMaxRange)
            ->setEstimatedMinRange($estimatedMinRange)
            ->setEstimatedThroughputSpeed($estimatedThroughputSpeed)
            ->setFixedRateCapacityDate($fixedRateCapacityDate)
            ->setFixedRateExchangeStatus($fixedRateExchangeStatus)
            ->setFixedRateLineStatus($fixedRateLineStatus)
            ->setFixedRateReadyDate($fixedRateReadyDate)
            ->setMaxAvailable($maxAvailable)
            ->setMaxCapacityDate($maxCapacityDate)
            ->setMaxExchangeStatus($maxExchangeStatus)
            ->setMaxReadyDate($maxReadyDate)
            ->setMinThreshold($minThreshold);
    }
    /**
     * Get EstimatedDownstreamSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedDownstreamSpeed()
    {
        return isset($this->EstimatedDownstreamSpeed) ? $this->EstimatedDownstreamSpeed : null;
    }
    /**
     * Set EstimatedDownstreamSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedDownstreamSpeed
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setEstimatedDownstreamSpeed($estimatedDownstreamSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDownstreamSpeed) && !is_string($estimatedDownstreamSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedDownstreamSpeed)), __LINE__);
        }
        if (is_null($estimatedDownstreamSpeed) || (is_array($estimatedDownstreamSpeed) && empty($estimatedDownstreamSpeed))) {
            unset($this->EstimatedDownstreamSpeed);
        } else {
            $this->EstimatedDownstreamSpeed = $estimatedDownstreamSpeed;
        }
        return $this;
    }
    /**
     * Get EstimatedMaxRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedMaxRange()
    {
        return isset($this->EstimatedMaxRange) ? $this->EstimatedMaxRange : null;
    }
    /**
     * Set EstimatedMaxRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedMaxRange
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setEstimatedMaxRange($estimatedMaxRange = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedMaxRange) && !is_string($estimatedMaxRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedMaxRange)), __LINE__);
        }
        if (is_null($estimatedMaxRange) || (is_array($estimatedMaxRange) && empty($estimatedMaxRange))) {
            unset($this->EstimatedMaxRange);
        } else {
            $this->EstimatedMaxRange = $estimatedMaxRange;
        }
        return $this;
    }
    /**
     * Get EstimatedMinRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedMinRange()
    {
        return isset($this->EstimatedMinRange) ? $this->EstimatedMinRange : null;
    }
    /**
     * Set EstimatedMinRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedMinRange
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setEstimatedMinRange($estimatedMinRange = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedMinRange) && !is_string($estimatedMinRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedMinRange)), __LINE__);
        }
        if (is_null($estimatedMinRange) || (is_array($estimatedMinRange) && empty($estimatedMinRange))) {
            unset($this->EstimatedMinRange);
        } else {
            $this->EstimatedMinRange = $estimatedMinRange;
        }
        return $this;
    }
    /**
     * Get EstimatedThroughputSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfThroughputSpeedType|null
     */
    public function getEstimatedThroughputSpeed()
    {
        return isset($this->EstimatedThroughputSpeed) ? $this->EstimatedThroughputSpeed : null;
    }
    /**
     * Set EstimatedThroughputSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setEstimatedThroughputSpeed(\ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed = null)
    {
        if (is_null($estimatedThroughputSpeed) || (is_array($estimatedThroughputSpeed) && empty($estimatedThroughputSpeed))) {
            unset($this->EstimatedThroughputSpeed);
        } else {
            $this->EstimatedThroughputSpeed = $estimatedThroughputSpeed;
        }
        return $this;
    }
    /**
     * Get FixedRateCapacityDate value
     * @return string|null
     */
    public function getFixedRateCapacityDate()
    {
        return $this->FixedRateCapacityDate;
    }
    /**
     * Set FixedRateCapacityDate value
     * @param string $fixedRateCapacityDate
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setFixedRateCapacityDate($fixedRateCapacityDate = null)
    {
        // validation for constraint: string
        if (!is_null($fixedRateCapacityDate) && !is_string($fixedRateCapacityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fixedRateCapacityDate)), __LINE__);
        }
        $this->FixedRateCapacityDate = $fixedRateCapacityDate;
        return $this;
    }
    /**
     * Get FixedRateExchangeStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFixedRateExchangeStatus()
    {
        return isset($this->FixedRateExchangeStatus) ? $this->FixedRateExchangeStatus : null;
    }
    /**
     * Set FixedRateExchangeStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fixedRateExchangeStatus
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setFixedRateExchangeStatus($fixedRateExchangeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($fixedRateExchangeStatus) && !is_string($fixedRateExchangeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fixedRateExchangeStatus)), __LINE__);
        }
        if (is_null($fixedRateExchangeStatus) || (is_array($fixedRateExchangeStatus) && empty($fixedRateExchangeStatus))) {
            unset($this->FixedRateExchangeStatus);
        } else {
            $this->FixedRateExchangeStatus = $fixedRateExchangeStatus;
        }
        return $this;
    }
    /**
     * Get FixedRateLineStatus value
     * @return int|null
     */
    public function getFixedRateLineStatus()
    {
        return $this->FixedRateLineStatus;
    }
    /**
     * Set FixedRateLineStatus value
     * @param int $fixedRateLineStatus
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setFixedRateLineStatus($fixedRateLineStatus = null)
    {
        // validation for constraint: int
        if (!is_null($fixedRateLineStatus) && !is_numeric($fixedRateLineStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fixedRateLineStatus)), __LINE__);
        }
        $this->FixedRateLineStatus = $fixedRateLineStatus;
        return $this;
    }
    /**
     * Get FixedRateReadyDate value
     * @return string|null
     */
    public function getFixedRateReadyDate()
    {
        return $this->FixedRateReadyDate;
    }
    /**
     * Set FixedRateReadyDate value
     * @param string $fixedRateReadyDate
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setFixedRateReadyDate($fixedRateReadyDate = null)
    {
        // validation for constraint: string
        if (!is_null($fixedRateReadyDate) && !is_string($fixedRateReadyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fixedRateReadyDate)), __LINE__);
        }
        $this->FixedRateReadyDate = $fixedRateReadyDate;
        return $this;
    }
    /**
     * Get MaxAvailable value
     * @return string|null
     */
    public function getMaxAvailable()
    {
        return $this->MaxAvailable;
    }
    /**
     * Set MaxAvailable value
     * @uses \EnumType\YesNoEnum::valueIsValid()
     * @uses \EnumType\YesNoEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxAvailable
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setMaxAvailable($maxAvailable = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoEnum::valueIsValid($maxAvailable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxAvailable, implode(', ', \EnumType\YesNoEnum::getValidValues())), __LINE__);
        }
        $this->MaxAvailable = $maxAvailable;
        return $this;
    }
    /**
     * Get MaxCapacityDate value
     * @return string|null
     */
    public function getMaxCapacityDate()
    {
        return $this->MaxCapacityDate;
    }
    /**
     * Set MaxCapacityDate value
     * @param string $maxCapacityDate
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setMaxCapacityDate($maxCapacityDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxCapacityDate) && !is_string($maxCapacityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxCapacityDate)), __LINE__);
        }
        $this->MaxCapacityDate = $maxCapacityDate;
        return $this;
    }
    /**
     * Get MaxExchangeStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxExchangeStatus()
    {
        return isset($this->MaxExchangeStatus) ? $this->MaxExchangeStatus : null;
    }
    /**
     * Set MaxExchangeStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxExchangeStatus
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setMaxExchangeStatus($maxExchangeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($maxExchangeStatus) && !is_string($maxExchangeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxExchangeStatus)), __LINE__);
        }
        if (is_null($maxExchangeStatus) || (is_array($maxExchangeStatus) && empty($maxExchangeStatus))) {
            unset($this->MaxExchangeStatus);
        } else {
            $this->MaxExchangeStatus = $maxExchangeStatus;
        }
        return $this;
    }
    /**
     * Get MaxReadyDate value
     * @return string|null
     */
    public function getMaxReadyDate()
    {
        return $this->MaxReadyDate;
    }
    /**
     * Set MaxReadyDate value
     * @param string $maxReadyDate
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setMaxReadyDate($maxReadyDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxReadyDate) && !is_string($maxReadyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxReadyDate)), __LINE__);
        }
        $this->MaxReadyDate = $maxReadyDate;
        return $this;
    }
    /**
     * Get MinThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinThreshold()
    {
        return isset($this->MinThreshold) ? $this->MinThreshold : null;
    }
    /**
     * Set MinThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minThreshold
     * @return \StructType\ADSLAvailabilityDetails
     */
    public function setMinThreshold($minThreshold = null)
    {
        // validation for constraint: string
        if (!is_null($minThreshold) && !is_string($minThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minThreshold)), __LINE__);
        }
        if (is_null($minThreshold) || (is_array($minThreshold) && empty($minThreshold))) {
            unset($this->MinThreshold);
        } else {
            $this->MinThreshold = $minThreshold;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ADSLAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
