<?php

namespace EnumType;

/**
 * This class stands for xDSLTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:xDSLTypeEnum
 * @subpackage Enumerations
 */
class XDSLTypeEnum
{
    /**
     * Constant for value 'G_992_5AnnexA'
     * @return string 'G_992_5AnnexA'
     */
    const VALUE_G_992_5_ANNEX_A = 'G_992_5AnnexA';
    /**
     * Constant for value 'G_992_5AnnexM'
     * @return string 'G_992_5AnnexM'
     */
    const VALUE_G_992_5_ANNEX_M = 'G_992_5AnnexM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_G_992_5_ANNEX_A
     * @uses self::VALUE_G_992_5_ANNEX_M
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_G_992_5_ANNEX_A,
            self::VALUE_G_992_5_ANNEX_M,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
