<?php

namespace EnumType;

/**
 * This class stands for EFMLineLengthMeasureType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EFMLineLengthMeasureType
 * @subpackage Enumerations
 */
class EFMLineLengthMeasureType
{
    /**
     * Constant for value 'CircuitLineLengthCalculated'
     * @return string 'CircuitLineLengthCalculated'
     */
    const VALUE_CIRCUIT_LINE_LENGTH_CALCULATED = 'CircuitLineLengthCalculated';
    /**
     * Constant for value 'CircuitLineLengthEstimate'
     * @return string 'CircuitLineLengthEstimate'
     */
    const VALUE_CIRCUIT_LINE_LENGTH_ESTIMATE = 'CircuitLineLengthEstimate';
    /**
     * Constant for value 'AggregatedCircuitLineLengthCalculated'
     * @return string 'AggregatedCircuitLineLengthCalculated'
     */
    const VALUE_AGGREGATED_CIRCUIT_LINE_LENGTH_CALCULATED = 'AggregatedCircuitLineLengthCalculated';
    /**
     * Constant for value 'AggregatedCircuitLineLengthEstimate'
     * @return string 'AggregatedCircuitLineLengthEstimate'
     */
    const VALUE_AGGREGATED_CIRCUIT_LINE_LENGTH_ESTIMATE = 'AggregatedCircuitLineLengthEstimate';
    /**
     * Constant for value 'DistributionPointLineLengthEstimate'
     * @return string 'DistributionPointLineLengthEstimate'
     */
    const VALUE_DISTRIBUTION_POINT_LINE_LENGTH_ESTIMATE = 'DistributionPointLineLengthEstimate';
    /**
     * Constant for value 'AggregatedDistributionPointLineLengthEstimate'
     * @return string 'AggregatedDistributionPointLineLengthEstimate'
     */
    const VALUE_AGGREGATED_DISTRIBUTION_POINT_LINE_LENGTH_ESTIMATE = 'AggregatedDistributionPointLineLengthEstimate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CIRCUIT_LINE_LENGTH_CALCULATED
     * @uses self::VALUE_CIRCUIT_LINE_LENGTH_ESTIMATE
     * @uses self::VALUE_AGGREGATED_CIRCUIT_LINE_LENGTH_CALCULATED
     * @uses self::VALUE_AGGREGATED_CIRCUIT_LINE_LENGTH_ESTIMATE
     * @uses self::VALUE_DISTRIBUTION_POINT_LINE_LENGTH_ESTIMATE
     * @uses self::VALUE_AGGREGATED_DISTRIBUTION_POINT_LINE_LENGTH_ESTIMATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CIRCUIT_LINE_LENGTH_CALCULATED,
            self::VALUE_CIRCUIT_LINE_LENGTH_ESTIMATE,
            self::VALUE_AGGREGATED_CIRCUIT_LINE_LENGTH_CALCULATED,
            self::VALUE_AGGREGATED_CIRCUIT_LINE_LENGTH_ESTIMATE,
            self::VALUE_DISTRIBUTION_POINT_LINE_LENGTH_ESTIMATE,
            self::VALUE_AGGREGATED_DISTRIBUTION_POINT_LINE_LENGTH_ESTIMATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
