<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductMessage ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfProductMessage
 * @subpackage Arrays
 */
class ArrayOfProductMessage extends AbstractStructArrayBase
{
    /**
     * The ProductMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductMessage[]
     */
    public $ProductMessage;
    /**
     * Constructor method for ArrayOfProductMessage
     * @uses ArrayOfProductMessage::setProductMessage()
     * @param \StructType\ProductMessage[] $productMessage
     */
    public function __construct(array $productMessage = array())
    {
        $this
            ->setProductMessage($productMessage);
    }
    /**
     * Get ProductMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductMessage[]|null
     */
    public function getProductMessage()
    {
        return isset($this->ProductMessage) ? $this->ProductMessage : null;
    }
    /**
     * Set ProductMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductMessage[] $productMessage
     * @return \ArrayType\ArrayOfProductMessage
     */
    public function setProductMessage(array $productMessage = array())
    {
        foreach ($productMessage as $arrayOfProductMessageProductMessageItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductMessageProductMessageItem instanceof \StructType\ProductMessage) {
                throw new \InvalidArgumentException(sprintf('The ProductMessage property can only contain items of \StructType\ProductMessage, "%s" given', is_object($arrayOfProductMessageProductMessageItem) ? get_class($arrayOfProductMessageProductMessageItem) : gettype($arrayOfProductMessageProductMessageItem)), __LINE__);
            }
        }
        if (is_null($productMessage) || (is_array($productMessage) && empty($productMessage))) {
            unset($this->ProductMessage);
        } else {
            $this->ProductMessage = $productMessage;
        }
        return $this;
    }
    /**
     * Add item to ProductMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductMessage $item
     * @return \ArrayType\ArrayOfProductMessage
     */
    public function addToProductMessage(\StructType\ProductMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductMessage) {
            throw new \InvalidArgumentException(sprintf('The ProductMessage property can only contain items of \StructType\ProductMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductMessage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductMessage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductMessage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductMessage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductMessage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductMessage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductMessage
     */
    public function getAttributeName()
    {
        return 'ProductMessage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
