<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductAttribute ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfProductAttribute
 * @subpackage Arrays
 */
class ArrayOfProductAttribute extends AbstractStructArrayBase
{
    /**
     * The ProductAttribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductAttribute[]
     */
    public $ProductAttribute;
    /**
     * Constructor method for ArrayOfProductAttribute
     * @uses ArrayOfProductAttribute::setProductAttribute()
     * @param \StructType\ProductAttribute[] $productAttribute
     */
    public function __construct(array $productAttribute = array())
    {
        $this
            ->setProductAttribute($productAttribute);
    }
    /**
     * Get ProductAttribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductAttribute[]|null
     */
    public function getProductAttribute()
    {
        return isset($this->ProductAttribute) ? $this->ProductAttribute : null;
    }
    /**
     * Set ProductAttribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductAttribute[] $productAttribute
     * @return \ArrayType\ArrayOfProductAttribute
     */
    public function setProductAttribute(array $productAttribute = array())
    {
        foreach ($productAttribute as $arrayOfProductAttributeProductAttributeItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductAttributeProductAttributeItem instanceof \StructType\ProductAttribute) {
                throw new \InvalidArgumentException(sprintf('The ProductAttribute property can only contain items of \StructType\ProductAttribute, "%s" given', is_object($arrayOfProductAttributeProductAttributeItem) ? get_class($arrayOfProductAttributeProductAttributeItem) : gettype($arrayOfProductAttributeProductAttributeItem)), __LINE__);
            }
        }
        if (is_null($productAttribute) || (is_array($productAttribute) && empty($productAttribute))) {
            unset($this->ProductAttribute);
        } else {
            $this->ProductAttribute = $productAttribute;
        }
        return $this;
    }
    /**
     * Add item to ProductAttribute value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductAttribute $item
     * @return \ArrayType\ArrayOfProductAttribute
     */
    public function addToProductAttribute(\StructType\ProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The ProductAttribute property can only contain items of \StructType\ProductAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductAttribute[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductAttribute|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductAttribute|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductAttribute|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductAttribute|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductAttribute|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductAttribute
     */
    public function getAttributeName()
    {
        return 'ProductAttribute';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductAttribute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
