<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderDetails ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOrderDetails
 * @subpackage Arrays
 */
class ArrayOfOrderDetails extends AbstractStructArrayBase
{
    /**
     * The OrderDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderDetails[]
     */
    public $OrderDetails;
    /**
     * Constructor method for ArrayOfOrderDetails
     * @uses ArrayOfOrderDetails::setOrderDetails()
     * @param \StructType\OrderDetails[] $orderDetails
     */
    public function __construct(array $orderDetails = array())
    {
        $this
            ->setOrderDetails($orderDetails);
    }
    /**
     * Get OrderDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderDetails[]|null
     */
    public function getOrderDetails()
    {
        return isset($this->OrderDetails) ? $this->OrderDetails : null;
    }
    /**
     * Set OrderDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDetails[] $orderDetails
     * @return \ArrayType\ArrayOfOrderDetails
     */
    public function setOrderDetails(array $orderDetails = array())
    {
        foreach ($orderDetails as $arrayOfOrderDetailsOrderDetailsItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderDetailsOrderDetailsItem instanceof \StructType\OrderDetails) {
                throw new \InvalidArgumentException(sprintf('The OrderDetails property can only contain items of \StructType\OrderDetails, "%s" given', is_object($arrayOfOrderDetailsOrderDetailsItem) ? get_class($arrayOfOrderDetailsOrderDetailsItem) : gettype($arrayOfOrderDetailsOrderDetailsItem)), __LINE__);
            }
        }
        if (is_null($orderDetails) || (is_array($orderDetails) && empty($orderDetails))) {
            unset($this->OrderDetails);
        } else {
            $this->OrderDetails = $orderDetails;
        }
        return $this;
    }
    /**
     * Add item to OrderDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDetails $item
     * @return \ArrayType\ArrayOfOrderDetails
     */
    public function addToOrderDetails(\StructType\OrderDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderDetails) {
            throw new \InvalidArgumentException(sprintf('The OrderDetails property can only contain items of \StructType\OrderDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderDetails|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderDetails|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderDetails|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderDetails|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderDetails|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderDetails
     */
    public function getAttributeName()
    {
        return 'OrderDetails';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOrderDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
