<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WBCAnnexMAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WBCAnnexMAvailabilityDetails
 * @subpackage Structs
 */
class WBCAnnexMAvailabilityDetails extends AbstractStructBase
{
    /**
     * The AnnexMAvailable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AnnexMAvailable;
    /**
     * The AnnexMDownStreamSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnnexMDownStreamSpeed;
    /**
     * The AnnexMMaxRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnnexMMaxRange;
    /**
     * The AnnexMMinRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnnexMMinRange;
    /**
     * The AnnexMUpStreamSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnnexMUpStreamSpeed;
    /**
     * The EstimatedThroughputSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfThroughputSpeedType
     */
    public $EstimatedThroughputSpeed;
    /**
     * Constructor method for WBCAnnexMAvailabilityDetails
     * @uses WBCAnnexMAvailabilityDetails::setAnnexMAvailable()
     * @uses WBCAnnexMAvailabilityDetails::setAnnexMDownStreamSpeed()
     * @uses WBCAnnexMAvailabilityDetails::setAnnexMMaxRange()
     * @uses WBCAnnexMAvailabilityDetails::setAnnexMMinRange()
     * @uses WBCAnnexMAvailabilityDetails::setAnnexMUpStreamSpeed()
     * @uses WBCAnnexMAvailabilityDetails::setEstimatedThroughputSpeed()
     * @param string $annexMAvailable
     * @param string $annexMDownStreamSpeed
     * @param string $annexMMaxRange
     * @param string $annexMMinRange
     * @param string $annexMUpStreamSpeed
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed
     */
    public function __construct($annexMAvailable = null, $annexMDownStreamSpeed = null, $annexMMaxRange = null, $annexMMinRange = null, $annexMUpStreamSpeed = null, \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed = null)
    {
        $this
            ->setAnnexMAvailable($annexMAvailable)
            ->setAnnexMDownStreamSpeed($annexMDownStreamSpeed)
            ->setAnnexMMaxRange($annexMMaxRange)
            ->setAnnexMMinRange($annexMMinRange)
            ->setAnnexMUpStreamSpeed($annexMUpStreamSpeed)
            ->setEstimatedThroughputSpeed($estimatedThroughputSpeed);
    }
    /**
     * Get AnnexMAvailable value
     * @return string|null
     */
    public function getAnnexMAvailable()
    {
        return $this->AnnexMAvailable;
    }
    /**
     * Set AnnexMAvailable value
     * @uses \EnumType\YesNoEnum::valueIsValid()
     * @uses \EnumType\YesNoEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $annexMAvailable
     * @return \StructType\WBCAnnexMAvailabilityDetails
     */
    public function setAnnexMAvailable($annexMAvailable = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoEnum::valueIsValid($annexMAvailable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $annexMAvailable, implode(', ', \EnumType\YesNoEnum::getValidValues())), __LINE__);
        }
        $this->AnnexMAvailable = $annexMAvailable;
        return $this;
    }
    /**
     * Get AnnexMDownStreamSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnexMDownStreamSpeed()
    {
        return isset($this->AnnexMDownStreamSpeed) ? $this->AnnexMDownStreamSpeed : null;
    }
    /**
     * Set AnnexMDownStreamSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $annexMDownStreamSpeed
     * @return \StructType\WBCAnnexMAvailabilityDetails
     */
    public function setAnnexMDownStreamSpeed($annexMDownStreamSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($annexMDownStreamSpeed) && !is_string($annexMDownStreamSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($annexMDownStreamSpeed)), __LINE__);
        }
        if (is_null($annexMDownStreamSpeed) || (is_array($annexMDownStreamSpeed) && empty($annexMDownStreamSpeed))) {
            unset($this->AnnexMDownStreamSpeed);
        } else {
            $this->AnnexMDownStreamSpeed = $annexMDownStreamSpeed;
        }
        return $this;
    }
    /**
     * Get AnnexMMaxRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnexMMaxRange()
    {
        return isset($this->AnnexMMaxRange) ? $this->AnnexMMaxRange : null;
    }
    /**
     * Set AnnexMMaxRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $annexMMaxRange
     * @return \StructType\WBCAnnexMAvailabilityDetails
     */
    public function setAnnexMMaxRange($annexMMaxRange = null)
    {
        // validation for constraint: string
        if (!is_null($annexMMaxRange) && !is_string($annexMMaxRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($annexMMaxRange)), __LINE__);
        }
        if (is_null($annexMMaxRange) || (is_array($annexMMaxRange) && empty($annexMMaxRange))) {
            unset($this->AnnexMMaxRange);
        } else {
            $this->AnnexMMaxRange = $annexMMaxRange;
        }
        return $this;
    }
    /**
     * Get AnnexMMinRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnexMMinRange()
    {
        return isset($this->AnnexMMinRange) ? $this->AnnexMMinRange : null;
    }
    /**
     * Set AnnexMMinRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $annexMMinRange
     * @return \StructType\WBCAnnexMAvailabilityDetails
     */
    public function setAnnexMMinRange($annexMMinRange = null)
    {
        // validation for constraint: string
        if (!is_null($annexMMinRange) && !is_string($annexMMinRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($annexMMinRange)), __LINE__);
        }
        if (is_null($annexMMinRange) || (is_array($annexMMinRange) && empty($annexMMinRange))) {
            unset($this->AnnexMMinRange);
        } else {
            $this->AnnexMMinRange = $annexMMinRange;
        }
        return $this;
    }
    /**
     * Get AnnexMUpStreamSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnexMUpStreamSpeed()
    {
        return isset($this->AnnexMUpStreamSpeed) ? $this->AnnexMUpStreamSpeed : null;
    }
    /**
     * Set AnnexMUpStreamSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $annexMUpStreamSpeed
     * @return \StructType\WBCAnnexMAvailabilityDetails
     */
    public function setAnnexMUpStreamSpeed($annexMUpStreamSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($annexMUpStreamSpeed) && !is_string($annexMUpStreamSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($annexMUpStreamSpeed)), __LINE__);
        }
        if (is_null($annexMUpStreamSpeed) || (is_array($annexMUpStreamSpeed) && empty($annexMUpStreamSpeed))) {
            unset($this->AnnexMUpStreamSpeed);
        } else {
            $this->AnnexMUpStreamSpeed = $annexMUpStreamSpeed;
        }
        return $this;
    }
    /**
     * Get EstimatedThroughputSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfThroughputSpeedType|null
     */
    public function getEstimatedThroughputSpeed()
    {
        return isset($this->EstimatedThroughputSpeed) ? $this->EstimatedThroughputSpeed : null;
    }
    /**
     * Set EstimatedThroughputSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed
     * @return \StructType\WBCAnnexMAvailabilityDetails
     */
    public function setEstimatedThroughputSpeed(\ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed = null)
    {
        if (is_null($estimatedThroughputSpeed) || (is_array($estimatedThroughputSpeed) && empty($estimatedThroughputSpeed))) {
            unset($this->EstimatedThroughputSpeed);
        } else {
            $this->EstimatedThroughputSpeed = $estimatedThroughputSpeed;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WBCAnnexMAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
