<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VNEAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:VNEAvailabilityDetails
 * @subpackage Structs
 */
class VNEAvailabilityDetails extends AvailabilityDetails
{
    /**
     * The PostCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostCode;
    /**
     * The UPRN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UPRN;
    /**
     * The VNEAvailability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfVNEAvailability
     */
    public $VNEAvailability;
    /**
     * Constructor method for VNEAvailabilityDetails
     * @uses VNEAvailabilityDetails::setPostCode()
     * @uses VNEAvailabilityDetails::setUPRN()
     * @uses VNEAvailabilityDetails::setVNEAvailability()
     * @param string $postCode
     * @param int $uPRN
     * @param \ArrayType\ArrayOfVNEAvailability $vNEAvailability
     */
    public function __construct($postCode = null, $uPRN = null, \ArrayType\ArrayOfVNEAvailability $vNEAvailability = null)
    {
        $this
            ->setPostCode($postCode)
            ->setUPRN($uPRN)
            ->setVNEAvailability($vNEAvailability);
    }
    /**
     * Get PostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostCode()
    {
        return isset($this->PostCode) ? $this->PostCode : null;
    }
    /**
     * Set PostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postCode
     * @return \StructType\VNEAvailabilityDetails
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        if (is_null($postCode) || (is_array($postCode) && empty($postCode))) {
            unset($this->PostCode);
        } else {
            $this->PostCode = $postCode;
        }
        return $this;
    }
    /**
     * Get UPRN value
     * @return int|null
     */
    public function getUPRN()
    {
        return $this->UPRN;
    }
    /**
     * Set UPRN value
     * @param int $uPRN
     * @return \StructType\VNEAvailabilityDetails
     */
    public function setUPRN($uPRN = null)
    {
        // validation for constraint: int
        if (!is_null($uPRN) && !is_numeric($uPRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uPRN)), __LINE__);
        }
        $this->UPRN = $uPRN;
        return $this;
    }
    /**
     * Get VNEAvailability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfVNEAvailability|null
     */
    public function getVNEAvailability()
    {
        return isset($this->VNEAvailability) ? $this->VNEAvailability : null;
    }
    /**
     * Set VNEAvailability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfVNEAvailability $vNEAvailability
     * @return \StructType\VNEAvailabilityDetails
     */
    public function setVNEAvailability(\ArrayType\ArrayOfVNEAvailability $vNEAvailability = null)
    {
        if (is_null($vNEAvailability) || (is_array($vNEAvailability) && empty($vNEAvailability))) {
            unset($this->VNEAvailability);
        } else {
            $this->VNEAvailability = $vNEAvailability;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VNEAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
