<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VNEAvailability StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:VNEAvailability
 * @subpackage Structs
 */
class VNEAvailability extends AbstractStructBase
{
    /**
     * The AvailabilityRefNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailabilityRefNo;
    /**
     * The MDFSiteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MDFSiteID;
    /**
     * The ResilienceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReslilienceInformationResult
     */
    public $ResilienceInformation;
    /**
     * The Zone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zone;
    /**
     * Constructor method for VNEAvailability
     * @uses VNEAvailability::setAvailabilityRefNo()
     * @uses VNEAvailability::setMDFSiteID()
     * @uses VNEAvailability::setResilienceInformation()
     * @uses VNEAvailability::setZone()
     * @param string $availabilityRefNo
     * @param string $mDFSiteID
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @param string $zone
     */
    public function __construct($availabilityRefNo = null, $mDFSiteID = null, \StructType\ReslilienceInformationResult $resilienceInformation = null, $zone = null)
    {
        $this
            ->setAvailabilityRefNo($availabilityRefNo)
            ->setMDFSiteID($mDFSiteID)
            ->setResilienceInformation($resilienceInformation)
            ->setZone($zone);
    }
    /**
     * Get AvailabilityRefNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailabilityRefNo()
    {
        return isset($this->AvailabilityRefNo) ? $this->AvailabilityRefNo : null;
    }
    /**
     * Set AvailabilityRefNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availabilityRefNo
     * @return \StructType\VNEAvailability
     */
    public function setAvailabilityRefNo($availabilityRefNo = null)
    {
        // validation for constraint: string
        if (!is_null($availabilityRefNo) && !is_string($availabilityRefNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availabilityRefNo)), __LINE__);
        }
        if (is_null($availabilityRefNo) || (is_array($availabilityRefNo) && empty($availabilityRefNo))) {
            unset($this->AvailabilityRefNo);
        } else {
            $this->AvailabilityRefNo = $availabilityRefNo;
        }
        return $this;
    }
    /**
     * Get MDFSiteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMDFSiteID()
    {
        return isset($this->MDFSiteID) ? $this->MDFSiteID : null;
    }
    /**
     * Set MDFSiteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mDFSiteID
     * @return \StructType\VNEAvailability
     */
    public function setMDFSiteID($mDFSiteID = null)
    {
        // validation for constraint: string
        if (!is_null($mDFSiteID) && !is_string($mDFSiteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mDFSiteID)), __LINE__);
        }
        if (is_null($mDFSiteID) || (is_array($mDFSiteID) && empty($mDFSiteID))) {
            unset($this->MDFSiteID);
        } else {
            $this->MDFSiteID = $mDFSiteID;
        }
        return $this;
    }
    /**
     * Get ResilienceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReslilienceInformationResult|null
     */
    public function getResilienceInformation()
    {
        return isset($this->ResilienceInformation) ? $this->ResilienceInformation : null;
    }
    /**
     * Set ResilienceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @return \StructType\VNEAvailability
     */
    public function setResilienceInformation(\StructType\ReslilienceInformationResult $resilienceInformation = null)
    {
        if (is_null($resilienceInformation) || (is_array($resilienceInformation) && empty($resilienceInformation))) {
            unset($this->ResilienceInformation);
        } else {
            $this->ResilienceInformation = $resilienceInformation;
        }
        return $this;
    }
    /**
     * Get Zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZone()
    {
        return isset($this->Zone) ? $this->Zone : null;
    }
    /**
     * Set Zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zone
     * @return \StructType\VNEAvailability
     */
    public function setZone($zone = null)
    {
        // validation for constraint: string
        if (!is_null($zone) && !is_string($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zone)), __LINE__);
        }
        if (is_null($zone) || (is_array($zone) && empty($zone))) {
            unset($this->Zone);
        } else {
            $this->Zone = $zone;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VNEAvailability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
