<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelephoneNumberAvailabilityRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TelephoneNumberAvailabilityRequest
 * @subpackage Structs
 */
class TelephoneNumberAvailabilityRequest extends AvailabilityRequest
{
    /**
     * The MACCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MACCode;
    /**
     * The PerformMPFACCheck
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PerformMPFACCheck;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The ProxyCLI
     * @var bool
     */
    public $ProxyCLI;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TelephoneNumber;
    /**
     * Constructor method for TelephoneNumberAvailabilityRequest
     * @uses TelephoneNumberAvailabilityRequest::setMACCode()
     * @uses TelephoneNumberAvailabilityRequest::setPerformMPFACCheck()
     * @uses TelephoneNumberAvailabilityRequest::setPostcode()
     * @uses TelephoneNumberAvailabilityRequest::setProxyCLI()
     * @uses TelephoneNumberAvailabilityRequest::setTelephoneNumber()
     * @param string $mACCode
     * @param string $performMPFACCheck
     * @param string $postcode
     * @param bool $proxyCLI
     * @param string $telephoneNumber
     */
    public function __construct($mACCode = null, $performMPFACCheck = null, $postcode = null, $proxyCLI = null, $telephoneNumber = null)
    {
        $this
            ->setMACCode($mACCode)
            ->setPerformMPFACCheck($performMPFACCheck)
            ->setPostcode($postcode)
            ->setProxyCLI($proxyCLI)
            ->setTelephoneNumber($telephoneNumber);
    }
    /**
     * Get MACCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMACCode()
    {
        return isset($this->MACCode) ? $this->MACCode : null;
    }
    /**
     * Set MACCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mACCode
     * @return \StructType\TelephoneNumberAvailabilityRequest
     */
    public function setMACCode($mACCode = null)
    {
        // validation for constraint: string
        if (!is_null($mACCode) && !is_string($mACCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mACCode)), __LINE__);
        }
        if (is_null($mACCode) || (is_array($mACCode) && empty($mACCode))) {
            unset($this->MACCode);
        } else {
            $this->MACCode = $mACCode;
        }
        return $this;
    }
    /**
     * Get PerformMPFACCheck value
     * @return string|null
     */
    public function getPerformMPFACCheck()
    {
        return $this->PerformMPFACCheck;
    }
    /**
     * Set PerformMPFACCheck value
     * @uses \EnumType\PerformMPFACCheckEnum::valueIsValid()
     * @uses \EnumType\PerformMPFACCheckEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $performMPFACCheck
     * @return \StructType\TelephoneNumberAvailabilityRequest
     */
    public function setPerformMPFACCheck($performMPFACCheck = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PerformMPFACCheckEnum::valueIsValid($performMPFACCheck)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $performMPFACCheck, implode(', ', \EnumType\PerformMPFACCheckEnum::getValidValues())), __LINE__);
        }
        $this->PerformMPFACCheck = $performMPFACCheck;
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\TelephoneNumberAvailabilityRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get ProxyCLI value
     * @return bool|null
     */
    public function getProxyCLI()
    {
        return $this->ProxyCLI;
    }
    /**
     * Set ProxyCLI value
     * @param bool $proxyCLI
     * @return \StructType\TelephoneNumberAvailabilityRequest
     */
    public function setProxyCLI($proxyCLI = null)
    {
        // validation for constraint: boolean
        if (!is_null($proxyCLI) && !is_bool($proxyCLI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($proxyCLI)), __LINE__);
        }
        $this->ProxyCLI = $proxyCLI;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * Set TelephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\TelephoneNumberAvailabilityRequest
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TelephoneNumberAvailabilityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
