<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Status StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Status
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfError
     */
    public $Errors;
    /**
     * The HasErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasErrors;
    /**
     * Constructor method for Status
     * @uses Status::setErrors()
     * @uses Status::setHasErrors()
     * @param \ArrayType\ArrayOfError $errors
     * @param bool $hasErrors
     */
    public function __construct(\ArrayType\ArrayOfError $errors = null, $hasErrors = null)
    {
        $this
            ->setErrors($errors)
            ->setHasErrors($hasErrors);
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfError|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfError $errors
     * @return \StructType\Status
     */
    public function setErrors(\ArrayType\ArrayOfError $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get HasErrors value
     * @return bool|null
     */
    public function getHasErrors()
    {
        return $this->HasErrors;
    }
    /**
     * Set HasErrors value
     * @param bool $hasErrors
     * @return \StructType\Status
     */
    public function setHasErrors($hasErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasErrors) && !is_bool($hasErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasErrors)), __LINE__);
        }
        $this->HasErrors = $hasErrors;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Status
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
