<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SMPFAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SMPFAvailabilityDetails
 * @subpackage Structs
 */
class SMPFAvailabilityDetails extends AvailabilityDetails
{
    /**
     * The AccessLineID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLineID;
    /**
     * The AccessLineStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLineStatus;
    /**
     * The AccessLineStatusGfast
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLineStatusGfast;
    /**
     * The AccessLineStatusVDSL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLineStatusVDSL;
    /**
     * The AdditionalInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdditionalInformation
     */
    public $AdditionalInformation;
    /**
     * The AddressKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressKey;
    /**
     * The CareLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CareLevel;
    /**
     * The CurrentCP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentCP;
    /**
     * The CurrentReseller
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentReseller;
    /**
     * The CurrentResellerAgentID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CurrentResellerAgentID;
    /**
     * The CurrentSyncSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DSLSpeedInformation
     */
    public $CurrentSyncSpeed;
    /**
     * The EstimatedSyncSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LLUSyncSpeedType
     */
    public $EstimatedSyncSpeed;
    /**
     * The EstimatedThroughputSpeedAnnexA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfThroughputSpeedType
     */
    public $EstimatedThroughputSpeedAnnexA;
    /**
     * The EstimatedThroughputSpeedAnnexM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfThroughputSpeedType
     */
    public $EstimatedThroughputSpeedAnnexM;
    /**
     * The ExchangeDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LLUExchangeInfo
     */
    public $ExchangeDetails;
    /**
     * The GoldAddressKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GoldAddressKey;
    /**
     * The LineTypeDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LineType
     */
    public $LineTypeDetails;
    /**
     * The ListOfExchangeDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLLUExchangeInfo
     */
    public $ListOfExchangeDetails;
    /**
     * The NumberPortingInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberPortingInformation;
    /**
     * The NumberRangeHolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberRangeHolder;
    /**
     * The ObservedSyncSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LLUObservedSyncSpeedType
     */
    public $ObservedSyncSpeed;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The PostcodeMatch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostcodeMatch;
    /**
     * The ProductMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductMessage
     */
    public $ProductMessages;
    /**
     * The ServiceIncompatibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceIncompatibility;
    /**
     * The TechnologyMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTechnologyMessage
     */
    public $TechnologyMessages;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TelephoneNumber;
    /**
     * Constructor method for SMPFAvailabilityDetails
     * @uses SMPFAvailabilityDetails::setAccessLineID()
     * @uses SMPFAvailabilityDetails::setAccessLineStatus()
     * @uses SMPFAvailabilityDetails::setAccessLineStatusGfast()
     * @uses SMPFAvailabilityDetails::setAccessLineStatusVDSL()
     * @uses SMPFAvailabilityDetails::setAdditionalInformation()
     * @uses SMPFAvailabilityDetails::setAddressKey()
     * @uses SMPFAvailabilityDetails::setCareLevel()
     * @uses SMPFAvailabilityDetails::setCurrentCP()
     * @uses SMPFAvailabilityDetails::setCurrentReseller()
     * @uses SMPFAvailabilityDetails::setCurrentResellerAgentID()
     * @uses SMPFAvailabilityDetails::setCurrentSyncSpeed()
     * @uses SMPFAvailabilityDetails::setEstimatedSyncSpeed()
     * @uses SMPFAvailabilityDetails::setEstimatedThroughputSpeedAnnexA()
     * @uses SMPFAvailabilityDetails::setEstimatedThroughputSpeedAnnexM()
     * @uses SMPFAvailabilityDetails::setExchangeDetails()
     * @uses SMPFAvailabilityDetails::setGoldAddressKey()
     * @uses SMPFAvailabilityDetails::setLineTypeDetails()
     * @uses SMPFAvailabilityDetails::setListOfExchangeDetails()
     * @uses SMPFAvailabilityDetails::setNumberPortingInformation()
     * @uses SMPFAvailabilityDetails::setNumberRangeHolder()
     * @uses SMPFAvailabilityDetails::setObservedSyncSpeed()
     * @uses SMPFAvailabilityDetails::setPostcode()
     * @uses SMPFAvailabilityDetails::setPostcodeMatch()
     * @uses SMPFAvailabilityDetails::setProductMessages()
     * @uses SMPFAvailabilityDetails::setServiceIncompatibility()
     * @uses SMPFAvailabilityDetails::setTechnologyMessages()
     * @uses SMPFAvailabilityDetails::setTelephoneNumber()
     * @param string $accessLineID
     * @param string $accessLineStatus
     * @param string $accessLineStatusGfast
     * @param string $accessLineStatusVDSL
     * @param \ArrayType\ArrayOfAdditionalInformation $additionalInformation
     * @param string $addressKey
     * @param string $careLevel
     * @param string $currentCP
     * @param string $currentReseller
     * @param int $currentResellerAgentID
     * @param \StructType\DSLSpeedInformation $currentSyncSpeed
     * @param \StructType\LLUSyncSpeedType $estimatedSyncSpeed
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedAnnexA
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedAnnexM
     * @param \StructType\LLUExchangeInfo $exchangeDetails
     * @param string $goldAddressKey
     * @param \StructType\LineType $lineTypeDetails
     * @param \ArrayType\ArrayOfLLUExchangeInfo $listOfExchangeDetails
     * @param string $numberPortingInformation
     * @param string $numberRangeHolder
     * @param \StructType\LLUObservedSyncSpeedType $observedSyncSpeed
     * @param string $postcode
     * @param string $postcodeMatch
     * @param \ArrayType\ArrayOfProductMessage $productMessages
     * @param string $serviceIncompatibility
     * @param \ArrayType\ArrayOfTechnologyMessage $technologyMessages
     * @param string $telephoneNumber
     */
    public function __construct($accessLineID = null, $accessLineStatus = null, $accessLineStatusGfast = null, $accessLineStatusVDSL = null, \ArrayType\ArrayOfAdditionalInformation $additionalInformation = null, $addressKey = null, $careLevel = null, $currentCP = null, $currentReseller = null, $currentResellerAgentID = null, \StructType\DSLSpeedInformation $currentSyncSpeed = null, \StructType\LLUSyncSpeedType $estimatedSyncSpeed = null, \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedAnnexA = null, \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedAnnexM = null, \StructType\LLUExchangeInfo $exchangeDetails = null, $goldAddressKey = null, \StructType\LineType $lineTypeDetails = null, \ArrayType\ArrayOfLLUExchangeInfo $listOfExchangeDetails = null, $numberPortingInformation = null, $numberRangeHolder = null, \StructType\LLUObservedSyncSpeedType $observedSyncSpeed = null, $postcode = null, $postcodeMatch = null, \ArrayType\ArrayOfProductMessage $productMessages = null, $serviceIncompatibility = null, \ArrayType\ArrayOfTechnologyMessage $technologyMessages = null, $telephoneNumber = null)
    {
        $this
            ->setAccessLineID($accessLineID)
            ->setAccessLineStatus($accessLineStatus)
            ->setAccessLineStatusGfast($accessLineStatusGfast)
            ->setAccessLineStatusVDSL($accessLineStatusVDSL)
            ->setAdditionalInformation($additionalInformation)
            ->setAddressKey($addressKey)
            ->setCareLevel($careLevel)
            ->setCurrentCP($currentCP)
            ->setCurrentReseller($currentReseller)
            ->setCurrentResellerAgentID($currentResellerAgentID)
            ->setCurrentSyncSpeed($currentSyncSpeed)
            ->setEstimatedSyncSpeed($estimatedSyncSpeed)
            ->setEstimatedThroughputSpeedAnnexA($estimatedThroughputSpeedAnnexA)
            ->setEstimatedThroughputSpeedAnnexM($estimatedThroughputSpeedAnnexM)
            ->setExchangeDetails($exchangeDetails)
            ->setGoldAddressKey($goldAddressKey)
            ->setLineTypeDetails($lineTypeDetails)
            ->setListOfExchangeDetails($listOfExchangeDetails)
            ->setNumberPortingInformation($numberPortingInformation)
            ->setNumberRangeHolder($numberRangeHolder)
            ->setObservedSyncSpeed($observedSyncSpeed)
            ->setPostcode($postcode)
            ->setPostcodeMatch($postcodeMatch)
            ->setProductMessages($productMessages)
            ->setServiceIncompatibility($serviceIncompatibility)
            ->setTechnologyMessages($technologyMessages)
            ->setTelephoneNumber($telephoneNumber);
    }
    /**
     * Get AccessLineID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLineID()
    {
        return isset($this->AccessLineID) ? $this->AccessLineID : null;
    }
    /**
     * Set AccessLineID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLineID
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setAccessLineID($accessLineID = null)
    {
        // validation for constraint: string
        if (!is_null($accessLineID) && !is_string($accessLineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLineID)), __LINE__);
        }
        if (is_null($accessLineID) || (is_array($accessLineID) && empty($accessLineID))) {
            unset($this->AccessLineID);
        } else {
            $this->AccessLineID = $accessLineID;
        }
        return $this;
    }
    /**
     * Get AccessLineStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLineStatus()
    {
        return isset($this->AccessLineStatus) ? $this->AccessLineStatus : null;
    }
    /**
     * Set AccessLineStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLineStatus
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setAccessLineStatus($accessLineStatus = null)
    {
        // validation for constraint: string
        if (!is_null($accessLineStatus) && !is_string($accessLineStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLineStatus)), __LINE__);
        }
        if (is_null($accessLineStatus) || (is_array($accessLineStatus) && empty($accessLineStatus))) {
            unset($this->AccessLineStatus);
        } else {
            $this->AccessLineStatus = $accessLineStatus;
        }
        return $this;
    }
    /**
     * Get AccessLineStatusGfast value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLineStatusGfast()
    {
        return isset($this->AccessLineStatusGfast) ? $this->AccessLineStatusGfast : null;
    }
    /**
     * Set AccessLineStatusGfast value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLineStatusGfast
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setAccessLineStatusGfast($accessLineStatusGfast = null)
    {
        // validation for constraint: string
        if (!is_null($accessLineStatusGfast) && !is_string($accessLineStatusGfast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLineStatusGfast)), __LINE__);
        }
        if (is_null($accessLineStatusGfast) || (is_array($accessLineStatusGfast) && empty($accessLineStatusGfast))) {
            unset($this->AccessLineStatusGfast);
        } else {
            $this->AccessLineStatusGfast = $accessLineStatusGfast;
        }
        return $this;
    }
    /**
     * Get AccessLineStatusVDSL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLineStatusVDSL()
    {
        return isset($this->AccessLineStatusVDSL) ? $this->AccessLineStatusVDSL : null;
    }
    /**
     * Set AccessLineStatusVDSL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLineStatusVDSL
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setAccessLineStatusVDSL($accessLineStatusVDSL = null)
    {
        // validation for constraint: string
        if (!is_null($accessLineStatusVDSL) && !is_string($accessLineStatusVDSL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLineStatusVDSL)), __LINE__);
        }
        if (is_null($accessLineStatusVDSL) || (is_array($accessLineStatusVDSL) && empty($accessLineStatusVDSL))) {
            unset($this->AccessLineStatusVDSL);
        } else {
            $this->AccessLineStatusVDSL = $accessLineStatusVDSL;
        }
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdditionalInformation|null
     */
    public function getAdditionalInformation()
    {
        return isset($this->AdditionalInformation) ? $this->AdditionalInformation : null;
    }
    /**
     * Set AdditionalInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdditionalInformation $additionalInformation
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setAdditionalInformation(\ArrayType\ArrayOfAdditionalInformation $additionalInformation = null)
    {
        if (is_null($additionalInformation) || (is_array($additionalInformation) && empty($additionalInformation))) {
            unset($this->AdditionalInformation);
        } else {
            $this->AdditionalInformation = $additionalInformation;
        }
        return $this;
    }
    /**
     * Get AddressKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressKey()
    {
        return isset($this->AddressKey) ? $this->AddressKey : null;
    }
    /**
     * Set AddressKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressKey
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setAddressKey($addressKey = null)
    {
        // validation for constraint: string
        if (!is_null($addressKey) && !is_string($addressKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressKey)), __LINE__);
        }
        if (is_null($addressKey) || (is_array($addressKey) && empty($addressKey))) {
            unset($this->AddressKey);
        } else {
            $this->AddressKey = $addressKey;
        }
        return $this;
    }
    /**
     * Get CareLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCareLevel()
    {
        return isset($this->CareLevel) ? $this->CareLevel : null;
    }
    /**
     * Set CareLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $careLevel
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setCareLevel($careLevel = null)
    {
        // validation for constraint: string
        if (!is_null($careLevel) && !is_string($careLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($careLevel)), __LINE__);
        }
        if (is_null($careLevel) || (is_array($careLevel) && empty($careLevel))) {
            unset($this->CareLevel);
        } else {
            $this->CareLevel = $careLevel;
        }
        return $this;
    }
    /**
     * Get CurrentCP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentCP()
    {
        return isset($this->CurrentCP) ? $this->CurrentCP : null;
    }
    /**
     * Set CurrentCP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentCP
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setCurrentCP($currentCP = null)
    {
        // validation for constraint: string
        if (!is_null($currentCP) && !is_string($currentCP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentCP)), __LINE__);
        }
        if (is_null($currentCP) || (is_array($currentCP) && empty($currentCP))) {
            unset($this->CurrentCP);
        } else {
            $this->CurrentCP = $currentCP;
        }
        return $this;
    }
    /**
     * Get CurrentReseller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentReseller()
    {
        return isset($this->CurrentReseller) ? $this->CurrentReseller : null;
    }
    /**
     * Set CurrentReseller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentReseller
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setCurrentReseller($currentReseller = null)
    {
        // validation for constraint: string
        if (!is_null($currentReseller) && !is_string($currentReseller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentReseller)), __LINE__);
        }
        if (is_null($currentReseller) || (is_array($currentReseller) && empty($currentReseller))) {
            unset($this->CurrentReseller);
        } else {
            $this->CurrentReseller = $currentReseller;
        }
        return $this;
    }
    /**
     * Get CurrentResellerAgentID value
     * @return int|null
     */
    public function getCurrentResellerAgentID()
    {
        return $this->CurrentResellerAgentID;
    }
    /**
     * Set CurrentResellerAgentID value
     * @param int $currentResellerAgentID
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setCurrentResellerAgentID($currentResellerAgentID = null)
    {
        // validation for constraint: int
        if (!is_null($currentResellerAgentID) && !is_numeric($currentResellerAgentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentResellerAgentID)), __LINE__);
        }
        $this->CurrentResellerAgentID = $currentResellerAgentID;
        return $this;
    }
    /**
     * Get CurrentSyncSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DSLSpeedInformation|null
     */
    public function getCurrentSyncSpeed()
    {
        return isset($this->CurrentSyncSpeed) ? $this->CurrentSyncSpeed : null;
    }
    /**
     * Set CurrentSyncSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DSLSpeedInformation $currentSyncSpeed
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setCurrentSyncSpeed(\StructType\DSLSpeedInformation $currentSyncSpeed = null)
    {
        if (is_null($currentSyncSpeed) || (is_array($currentSyncSpeed) && empty($currentSyncSpeed))) {
            unset($this->CurrentSyncSpeed);
        } else {
            $this->CurrentSyncSpeed = $currentSyncSpeed;
        }
        return $this;
    }
    /**
     * Get EstimatedSyncSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LLUSyncSpeedType|null
     */
    public function getEstimatedSyncSpeed()
    {
        return isset($this->EstimatedSyncSpeed) ? $this->EstimatedSyncSpeed : null;
    }
    /**
     * Set EstimatedSyncSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LLUSyncSpeedType $estimatedSyncSpeed
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setEstimatedSyncSpeed(\StructType\LLUSyncSpeedType $estimatedSyncSpeed = null)
    {
        if (is_null($estimatedSyncSpeed) || (is_array($estimatedSyncSpeed) && empty($estimatedSyncSpeed))) {
            unset($this->EstimatedSyncSpeed);
        } else {
            $this->EstimatedSyncSpeed = $estimatedSyncSpeed;
        }
        return $this;
    }
    /**
     * Get EstimatedThroughputSpeedAnnexA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfThroughputSpeedType|null
     */
    public function getEstimatedThroughputSpeedAnnexA()
    {
        return isset($this->EstimatedThroughputSpeedAnnexA) ? $this->EstimatedThroughputSpeedAnnexA : null;
    }
    /**
     * Set EstimatedThroughputSpeedAnnexA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedAnnexA
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setEstimatedThroughputSpeedAnnexA(\ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedAnnexA = null)
    {
        if (is_null($estimatedThroughputSpeedAnnexA) || (is_array($estimatedThroughputSpeedAnnexA) && empty($estimatedThroughputSpeedAnnexA))) {
            unset($this->EstimatedThroughputSpeedAnnexA);
        } else {
            $this->EstimatedThroughputSpeedAnnexA = $estimatedThroughputSpeedAnnexA;
        }
        return $this;
    }
    /**
     * Get EstimatedThroughputSpeedAnnexM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfThroughputSpeedType|null
     */
    public function getEstimatedThroughputSpeedAnnexM()
    {
        return isset($this->EstimatedThroughputSpeedAnnexM) ? $this->EstimatedThroughputSpeedAnnexM : null;
    }
    /**
     * Set EstimatedThroughputSpeedAnnexM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedAnnexM
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setEstimatedThroughputSpeedAnnexM(\ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedAnnexM = null)
    {
        if (is_null($estimatedThroughputSpeedAnnexM) || (is_array($estimatedThroughputSpeedAnnexM) && empty($estimatedThroughputSpeedAnnexM))) {
            unset($this->EstimatedThroughputSpeedAnnexM);
        } else {
            $this->EstimatedThroughputSpeedAnnexM = $estimatedThroughputSpeedAnnexM;
        }
        return $this;
    }
    /**
     * Get ExchangeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LLUExchangeInfo|null
     */
    public function getExchangeDetails()
    {
        return isset($this->ExchangeDetails) ? $this->ExchangeDetails : null;
    }
    /**
     * Set ExchangeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LLUExchangeInfo $exchangeDetails
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setExchangeDetails(\StructType\LLUExchangeInfo $exchangeDetails = null)
    {
        if (is_null($exchangeDetails) || (is_array($exchangeDetails) && empty($exchangeDetails))) {
            unset($this->ExchangeDetails);
        } else {
            $this->ExchangeDetails = $exchangeDetails;
        }
        return $this;
    }
    /**
     * Get GoldAddressKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGoldAddressKey()
    {
        return isset($this->GoldAddressKey) ? $this->GoldAddressKey : null;
    }
    /**
     * Set GoldAddressKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $goldAddressKey
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setGoldAddressKey($goldAddressKey = null)
    {
        // validation for constraint: string
        if (!is_null($goldAddressKey) && !is_string($goldAddressKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goldAddressKey)), __LINE__);
        }
        if (is_null($goldAddressKey) || (is_array($goldAddressKey) && empty($goldAddressKey))) {
            unset($this->GoldAddressKey);
        } else {
            $this->GoldAddressKey = $goldAddressKey;
        }
        return $this;
    }
    /**
     * Get LineTypeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LineType|null
     */
    public function getLineTypeDetails()
    {
        return isset($this->LineTypeDetails) ? $this->LineTypeDetails : null;
    }
    /**
     * Set LineTypeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LineType $lineTypeDetails
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setLineTypeDetails(\StructType\LineType $lineTypeDetails = null)
    {
        if (is_null($lineTypeDetails) || (is_array($lineTypeDetails) && empty($lineTypeDetails))) {
            unset($this->LineTypeDetails);
        } else {
            $this->LineTypeDetails = $lineTypeDetails;
        }
        return $this;
    }
    /**
     * Get ListOfExchangeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLLUExchangeInfo|null
     */
    public function getListOfExchangeDetails()
    {
        return isset($this->ListOfExchangeDetails) ? $this->ListOfExchangeDetails : null;
    }
    /**
     * Set ListOfExchangeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLLUExchangeInfo $listOfExchangeDetails
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setListOfExchangeDetails(\ArrayType\ArrayOfLLUExchangeInfo $listOfExchangeDetails = null)
    {
        if (is_null($listOfExchangeDetails) || (is_array($listOfExchangeDetails) && empty($listOfExchangeDetails))) {
            unset($this->ListOfExchangeDetails);
        } else {
            $this->ListOfExchangeDetails = $listOfExchangeDetails;
        }
        return $this;
    }
    /**
     * Get NumberPortingInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberPortingInformation()
    {
        return isset($this->NumberPortingInformation) ? $this->NumberPortingInformation : null;
    }
    /**
     * Set NumberPortingInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberPortingInformation
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setNumberPortingInformation($numberPortingInformation = null)
    {
        // validation for constraint: string
        if (!is_null($numberPortingInformation) && !is_string($numberPortingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberPortingInformation)), __LINE__);
        }
        if (is_null($numberPortingInformation) || (is_array($numberPortingInformation) && empty($numberPortingInformation))) {
            unset($this->NumberPortingInformation);
        } else {
            $this->NumberPortingInformation = $numberPortingInformation;
        }
        return $this;
    }
    /**
     * Get NumberRangeHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberRangeHolder()
    {
        return isset($this->NumberRangeHolder) ? $this->NumberRangeHolder : null;
    }
    /**
     * Set NumberRangeHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberRangeHolder
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setNumberRangeHolder($numberRangeHolder = null)
    {
        // validation for constraint: string
        if (!is_null($numberRangeHolder) && !is_string($numberRangeHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberRangeHolder)), __LINE__);
        }
        if (is_null($numberRangeHolder) || (is_array($numberRangeHolder) && empty($numberRangeHolder))) {
            unset($this->NumberRangeHolder);
        } else {
            $this->NumberRangeHolder = $numberRangeHolder;
        }
        return $this;
    }
    /**
     * Get ObservedSyncSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LLUObservedSyncSpeedType|null
     */
    public function getObservedSyncSpeed()
    {
        return isset($this->ObservedSyncSpeed) ? $this->ObservedSyncSpeed : null;
    }
    /**
     * Set ObservedSyncSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LLUObservedSyncSpeedType $observedSyncSpeed
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setObservedSyncSpeed(\StructType\LLUObservedSyncSpeedType $observedSyncSpeed = null)
    {
        if (is_null($observedSyncSpeed) || (is_array($observedSyncSpeed) && empty($observedSyncSpeed))) {
            unset($this->ObservedSyncSpeed);
        } else {
            $this->ObservedSyncSpeed = $observedSyncSpeed;
        }
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get PostcodeMatch value
     * @return string|null
     */
    public function getPostcodeMatch()
    {
        return $this->PostcodeMatch;
    }
    /**
     * Set PostcodeMatch value
     * @uses \EnumType\NotSetYesNoEnum::valueIsValid()
     * @uses \EnumType\NotSetYesNoEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postcodeMatch
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setPostcodeMatch($postcodeMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NotSetYesNoEnum::valueIsValid($postcodeMatch)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $postcodeMatch, implode(', ', \EnumType\NotSetYesNoEnum::getValidValues())), __LINE__);
        }
        $this->PostcodeMatch = $postcodeMatch;
        return $this;
    }
    /**
     * Get ProductMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductMessage|null
     */
    public function getProductMessages()
    {
        return isset($this->ProductMessages) ? $this->ProductMessages : null;
    }
    /**
     * Set ProductMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductMessage $productMessages
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setProductMessages(\ArrayType\ArrayOfProductMessage $productMessages = null)
    {
        if (is_null($productMessages) || (is_array($productMessages) && empty($productMessages))) {
            unset($this->ProductMessages);
        } else {
            $this->ProductMessages = $productMessages;
        }
        return $this;
    }
    /**
     * Get ServiceIncompatibility value
     * @return string|null
     */
    public function getServiceIncompatibility()
    {
        return $this->ServiceIncompatibility;
    }
    /**
     * Set ServiceIncompatibility value
     * @uses \EnumType\ServiceIncompatibilityEnum::valueIsValid()
     * @uses \EnumType\ServiceIncompatibilityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceIncompatibility
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setServiceIncompatibility($serviceIncompatibility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceIncompatibilityEnum::valueIsValid($serviceIncompatibility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceIncompatibility, implode(', ', \EnumType\ServiceIncompatibilityEnum::getValidValues())), __LINE__);
        }
        $this->ServiceIncompatibility = $serviceIncompatibility;
        return $this;
    }
    /**
     * Get TechnologyMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTechnologyMessage|null
     */
    public function getTechnologyMessages()
    {
        return isset($this->TechnologyMessages) ? $this->TechnologyMessages : null;
    }
    /**
     * Set TechnologyMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTechnologyMessage $technologyMessages
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setTechnologyMessages(\ArrayType\ArrayOfTechnologyMessage $technologyMessages = null)
    {
        if (is_null($technologyMessages) || (is_array($technologyMessages) && empty($technologyMessages))) {
            unset($this->TechnologyMessages);
        } else {
            $this->TechnologyMessages = $technologyMessages;
        }
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return isset($this->TelephoneNumber) ? $this->TelephoneNumber : null;
    }
    /**
     * Set TelephoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telephoneNumber
     * @return \StructType\SMPFAvailabilityDetails
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        if (is_null($telephoneNumber) || (is_array($telephoneNumber) && empty($telephoneNumber))) {
            unset($this->TelephoneNumber);
        } else {
            $this->TelephoneNumber = $telephoneNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SMPFAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
