<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReslilienceInformationResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReslilienceInformationResult
 * @subpackage Structs
 */
class ReslilienceInformationResult extends AbstractStructBase
{
    /**
     * The FutureResilience
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FutureResilience
     */
    public $FutureResilience;
    /**
     * The ResilientLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResilientLevel;
    /**
     * Constructor method for ReslilienceInformationResult
     * @uses ReslilienceInformationResult::setFutureResilience()
     * @uses ReslilienceInformationResult::setResilientLevel()
     * @param \StructType\FutureResilience $futureResilience
     * @param string $resilientLevel
     */
    public function __construct(\StructType\FutureResilience $futureResilience = null, $resilientLevel = null)
    {
        $this
            ->setFutureResilience($futureResilience)
            ->setResilientLevel($resilientLevel);
    }
    /**
     * Get FutureResilience value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FutureResilience|null
     */
    public function getFutureResilience()
    {
        return isset($this->FutureResilience) ? $this->FutureResilience : null;
    }
    /**
     * Set FutureResilience value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FutureResilience $futureResilience
     * @return \StructType\ReslilienceInformationResult
     */
    public function setFutureResilience(\StructType\FutureResilience $futureResilience = null)
    {
        if (is_null($futureResilience) || (is_array($futureResilience) && empty($futureResilience))) {
            unset($this->FutureResilience);
        } else {
            $this->FutureResilience = $futureResilience;
        }
        return $this;
    }
    /**
     * Get ResilientLevel value
     * @return string|null
     */
    public function getResilientLevel()
    {
        return $this->ResilientLevel;
    }
    /**
     * Set ResilientLevel value
     * @uses \EnumType\ResilienceLevelEnum::valueIsValid()
     * @uses \EnumType\ResilienceLevelEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resilientLevel
     * @return \StructType\ReslilienceInformationResult
     */
    public function setResilientLevel($resilientLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResilienceLevelEnum::valueIsValid($resilientLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resilientLevel, implode(', ', \EnumType\ResilienceLevelEnum::getValidValues())), __LINE__);
        }
        $this->ResilientLevel = $resilientLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReslilienceInformationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
