<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderDetails
 * @subpackage Structs
 */
class OrderDetails extends AbstractStructBase
{
    /**
     * The CommandID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CommandID;
    /**
     * The CommandType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommandType;
    /**
     * The ResellerAccountReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResellerAccountReference;
    /**
     * The ResellerReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResellerReference;
    /**
     * Constructor method for OrderDetails
     * @uses OrderDetails::setCommandID()
     * @uses OrderDetails::setCommandType()
     * @uses OrderDetails::setResellerAccountReference()
     * @uses OrderDetails::setResellerReference()
     * @param int $commandID
     * @param string $commandType
     * @param string $resellerAccountReference
     * @param string $resellerReference
     */
    public function __construct($commandID = null, $commandType = null, $resellerAccountReference = null, $resellerReference = null)
    {
        $this
            ->setCommandID($commandID)
            ->setCommandType($commandType)
            ->setResellerAccountReference($resellerAccountReference)
            ->setResellerReference($resellerReference);
    }
    /**
     * Get CommandID value
     * @return int|null
     */
    public function getCommandID()
    {
        return $this->CommandID;
    }
    /**
     * Set CommandID value
     * @param int $commandID
     * @return \StructType\OrderDetails
     */
    public function setCommandID($commandID = null)
    {
        // validation for constraint: int
        if (!is_null($commandID) && !is_numeric($commandID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($commandID)), __LINE__);
        }
        $this->CommandID = $commandID;
        return $this;
    }
    /**
     * Get CommandType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommandType()
    {
        return isset($this->CommandType) ? $this->CommandType : null;
    }
    /**
     * Set CommandType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commandType
     * @return \StructType\OrderDetails
     */
    public function setCommandType($commandType = null)
    {
        // validation for constraint: string
        if (!is_null($commandType) && !is_string($commandType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commandType)), __LINE__);
        }
        if (is_null($commandType) || (is_array($commandType) && empty($commandType))) {
            unset($this->CommandType);
        } else {
            $this->CommandType = $commandType;
        }
        return $this;
    }
    /**
     * Get ResellerAccountReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResellerAccountReference()
    {
        return isset($this->ResellerAccountReference) ? $this->ResellerAccountReference : null;
    }
    /**
     * Set ResellerAccountReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resellerAccountReference
     * @return \StructType\OrderDetails
     */
    public function setResellerAccountReference($resellerAccountReference = null)
    {
        // validation for constraint: string
        if (!is_null($resellerAccountReference) && !is_string($resellerAccountReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resellerAccountReference)), __LINE__);
        }
        if (is_null($resellerAccountReference) || (is_array($resellerAccountReference) && empty($resellerAccountReference))) {
            unset($this->ResellerAccountReference);
        } else {
            $this->ResellerAccountReference = $resellerAccountReference;
        }
        return $this;
    }
    /**
     * Get ResellerReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResellerReference()
    {
        return isset($this->ResellerReference) ? $this->ResellerReference : null;
    }
    /**
     * Set ResellerReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resellerReference
     * @return \StructType\OrderDetails
     */
    public function setResellerReference($resellerReference = null)
    {
        // validation for constraint: string
        if (!is_null($resellerReference) && !is_string($resellerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resellerReference)), __LINE__);
        }
        if (is_null($resellerReference) || (is_array($resellerReference) && empty($resellerReference))) {
            unset($this->ResellerReference);
        } else {
            $this->ResellerReference = $resellerReference;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
