<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffnetExchangeDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OffnetExchangeDetails
 * @subpackage Structs
 */
class OffnetExchangeDetails extends AbstractStructBase
{
    /**
     * The ExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeCode;
    /**
     * The ExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeName;
    /**
     * The ProductMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductMessage
     */
    public $ProductMessages;
    /**
     * The ResilienceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReslilienceInformationResult
     */
    public $ResilienceInformation;
    /**
     * Constructor method for OffnetExchangeDetails
     * @uses OffnetExchangeDetails::setExchangeCode()
     * @uses OffnetExchangeDetails::setExchangeName()
     * @uses OffnetExchangeDetails::setProductMessages()
     * @uses OffnetExchangeDetails::setResilienceInformation()
     * @param string $exchangeCode
     * @param string $exchangeName
     * @param \ArrayType\ArrayOfProductMessage $productMessages
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     */
    public function __construct($exchangeCode = null, $exchangeName = null, \ArrayType\ArrayOfProductMessage $productMessages = null, \StructType\ReslilienceInformationResult $resilienceInformation = null)
    {
        $this
            ->setExchangeCode($exchangeCode)
            ->setExchangeName($exchangeName)
            ->setProductMessages($productMessages)
            ->setResilienceInformation($resilienceInformation);
    }
    /**
     * Get ExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeCode()
    {
        return isset($this->ExchangeCode) ? $this->ExchangeCode : null;
    }
    /**
     * Set ExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exchangeCode
     * @return \StructType\OffnetExchangeDetails
     */
    public function setExchangeCode($exchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeCode) && !is_string($exchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeCode)), __LINE__);
        }
        if (is_null($exchangeCode) || (is_array($exchangeCode) && empty($exchangeCode))) {
            unset($this->ExchangeCode);
        } else {
            $this->ExchangeCode = $exchangeCode;
        }
        return $this;
    }
    /**
     * Get ExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeName()
    {
        return isset($this->ExchangeName) ? $this->ExchangeName : null;
    }
    /**
     * Set ExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exchangeName
     * @return \StructType\OffnetExchangeDetails
     */
    public function setExchangeName($exchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeName) && !is_string($exchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeName)), __LINE__);
        }
        if (is_null($exchangeName) || (is_array($exchangeName) && empty($exchangeName))) {
            unset($this->ExchangeName);
        } else {
            $this->ExchangeName = $exchangeName;
        }
        return $this;
    }
    /**
     * Get ProductMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductMessage|null
     */
    public function getProductMessages()
    {
        return isset($this->ProductMessages) ? $this->ProductMessages : null;
    }
    /**
     * Set ProductMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductMessage $productMessages
     * @return \StructType\OffnetExchangeDetails
     */
    public function setProductMessages(\ArrayType\ArrayOfProductMessage $productMessages = null)
    {
        if (is_null($productMessages) || (is_array($productMessages) && empty($productMessages))) {
            unset($this->ProductMessages);
        } else {
            $this->ProductMessages = $productMessages;
        }
        return $this;
    }
    /**
     * Get ResilienceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReslilienceInformationResult|null
     */
    public function getResilienceInformation()
    {
        return isset($this->ResilienceInformation) ? $this->ResilienceInformation : null;
    }
    /**
     * Set ResilienceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @return \StructType\OffnetExchangeDetails
     */
    public function setResilienceInformation(\StructType\ReslilienceInformationResult $resilienceInformation = null)
    {
        if (is_null($resilienceInformation) || (is_array($resilienceInformation) && empty($resilienceInformation))) {
            unset($this->ResilienceInformation);
        } else {
            $this->ResilienceInformation = $resilienceInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OffnetExchangeDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
