<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonGALKAvailabilityRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NonGALKAvailabilityRequest
 * @subpackage Structs
 */
class NonGALKAvailabilityRequest extends AvailabilityRequest
{
    /**
     * The NonGoldAddressKey
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $NonGoldAddressKey;
    /**
     * The PerformMPFACCheck
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PerformMPFACCheck;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * Constructor method for NonGALKAvailabilityRequest
     * @uses NonGALKAvailabilityRequest::setNonGoldAddressKey()
     * @uses NonGALKAvailabilityRequest::setPerformMPFACCheck()
     * @uses NonGALKAvailabilityRequest::setPostcode()
     * @param string $nonGoldAddressKey
     * @param string $performMPFACCheck
     * @param string $postcode
     */
    public function __construct($nonGoldAddressKey = null, $performMPFACCheck = null, $postcode = null)
    {
        $this
            ->setNonGoldAddressKey($nonGoldAddressKey)
            ->setPerformMPFACCheck($performMPFACCheck)
            ->setPostcode($postcode);
    }
    /**
     * Get NonGoldAddressKey value
     * @return string|null
     */
    public function getNonGoldAddressKey()
    {
        return $this->NonGoldAddressKey;
    }
    /**
     * Set NonGoldAddressKey value
     * @param string $nonGoldAddressKey
     * @return \StructType\NonGALKAvailabilityRequest
     */
    public function setNonGoldAddressKey($nonGoldAddressKey = null)
    {
        // validation for constraint: string
        if (!is_null($nonGoldAddressKey) && !is_string($nonGoldAddressKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nonGoldAddressKey)), __LINE__);
        }
        $this->NonGoldAddressKey = $nonGoldAddressKey;
        return $this;
    }
    /**
     * Get PerformMPFACCheck value
     * @return string|null
     */
    public function getPerformMPFACCheck()
    {
        return $this->PerformMPFACCheck;
    }
    /**
     * Set PerformMPFACCheck value
     * @uses \EnumType\PerformMPFACCheckEnum::valueIsValid()
     * @uses \EnumType\PerformMPFACCheckEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $performMPFACCheck
     * @return \StructType\NonGALKAvailabilityRequest
     */
    public function setPerformMPFACCheck($performMPFACCheck = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PerformMPFACCheckEnum::valueIsValid($performMPFACCheck)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $performMPFACCheck, implode(', ', \EnumType\PerformMPFACCheckEnum::getValidValues())), __LINE__);
        }
        $this->PerformMPFACCheck = $performMPFACCheck;
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\NonGALKAvailabilityRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NonGALKAvailabilityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
