<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NominatedCLIRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NominatedCLIRequest
 * @subpackage Structs
 */
class NominatedCLIRequest extends AbstractStructBase
{
    /**
     * The CLI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CLI;
    /**
     * The NumberRetentionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberRetentionCode;
    /**
     * The Retain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Retain;
    /**
     * Constructor method for NominatedCLIRequest
     * @uses NominatedCLIRequest::setCLI()
     * @uses NominatedCLIRequest::setNumberRetentionCode()
     * @uses NominatedCLIRequest::setRetain()
     * @param string $cLI
     * @param string $numberRetentionCode
     * @param string $retain
     */
    public function __construct($cLI = null, $numberRetentionCode = null, $retain = null)
    {
        $this
            ->setCLI($cLI)
            ->setNumberRetentionCode($numberRetentionCode)
            ->setRetain($retain);
    }
    /**
     * Get CLI value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCLI()
    {
        return isset($this->CLI) ? $this->CLI : null;
    }
    /**
     * Set CLI value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cLI
     * @return \StructType\NominatedCLIRequest
     */
    public function setCLI($cLI = null)
    {
        // validation for constraint: string
        if (!is_null($cLI) && !is_string($cLI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cLI)), __LINE__);
        }
        if (is_null($cLI) || (is_array($cLI) && empty($cLI))) {
            unset($this->CLI);
        } else {
            $this->CLI = $cLI;
        }
        return $this;
    }
    /**
     * Get NumberRetentionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberRetentionCode()
    {
        return isset($this->NumberRetentionCode) ? $this->NumberRetentionCode : null;
    }
    /**
     * Set NumberRetentionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberRetentionCode
     * @return \StructType\NominatedCLIRequest
     */
    public function setNumberRetentionCode($numberRetentionCode = null)
    {
        // validation for constraint: string
        if (!is_null($numberRetentionCode) && !is_string($numberRetentionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberRetentionCode)), __LINE__);
        }
        if (is_null($numberRetentionCode) || (is_array($numberRetentionCode) && empty($numberRetentionCode))) {
            unset($this->NumberRetentionCode);
        } else {
            $this->NumberRetentionCode = $numberRetentionCode;
        }
        return $this;
    }
    /**
     * Get Retain value
     * @return string|null
     */
    public function getRetain()
    {
        return $this->Retain;
    }
    /**
     * Set Retain value
     * @uses \EnumType\RetainEnum::valueIsValid()
     * @uses \EnumType\RetainEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retain
     * @return \StructType\NominatedCLIRequest
     */
    public function setRetain($retain = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetainEnum::valueIsValid($retain)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retain, implode(', ', \EnumType\RetainEnum::getValidValues())), __LINE__);
        }
        $this->Retain = $retain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NominatedCLIRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
