<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NGAAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NGAAvailabilityDetails
 * @subpackage Structs
 */
class NGAAvailabilityDetails extends AvailabilityDetails
{
    /**
     * The ExistingServicesDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceInfo
     */
    public $ExistingServicesDetails;
    /**
     * The FTTCAvailability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FTTCInfo
     */
    public $FTTCAvailability;
    /**
     * The FTTCGfastAvailability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FTTCInfo
     */
    public $FTTCGfastAvailability;
    /**
     * The GoldAddressKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GoldAddressKey;
    /**
     * The ObservedSyncSpeedGFast
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FTTCObservedSyncSpeedType
     */
    public $ObservedSyncSpeedGFast;
    /**
     * The ObservedSyncSpeedLLU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LLUObservedSyncSpeedType
     */
    public $ObservedSyncSpeedLLU;
    /**
     * The ObservedSyncSpeedVDSL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FTTCObservedSyncSpeedType
     */
    public $ObservedSyncSpeedVDSL;
    /**
     * The OpenOrderDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOpenOrderInfo
     */
    public $OpenOrderDetails;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The PostcodeMatch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PostcodeMatchInfo
     */
    public $PostcodeMatch;
    /**
     * The PostcodeRAGCoverage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RAGPercentageCoverage
     */
    public $PostcodeRAGCoverage;
    /**
     * The ProductMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNGAProductMessage
     */
    public $ProductMessages;
    /**
     * The ServiceIncompatibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceIncompatibility;
    /**
     * The TechnologyMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTechnologyMessage
     */
    public $TechnologyMessages;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TelephoneNumber;
    /**
     * Constructor method for NGAAvailabilityDetails
     * @uses NGAAvailabilityDetails::setExistingServicesDetails()
     * @uses NGAAvailabilityDetails::setFTTCAvailability()
     * @uses NGAAvailabilityDetails::setFTTCGfastAvailability()
     * @uses NGAAvailabilityDetails::setGoldAddressKey()
     * @uses NGAAvailabilityDetails::setObservedSyncSpeedGFast()
     * @uses NGAAvailabilityDetails::setObservedSyncSpeedLLU()
     * @uses NGAAvailabilityDetails::setObservedSyncSpeedVDSL()
     * @uses NGAAvailabilityDetails::setOpenOrderDetails()
     * @uses NGAAvailabilityDetails::setPostcode()
     * @uses NGAAvailabilityDetails::setPostcodeMatch()
     * @uses NGAAvailabilityDetails::setPostcodeRAGCoverage()
     * @uses NGAAvailabilityDetails::setProductMessages()
     * @uses NGAAvailabilityDetails::setServiceIncompatibility()
     * @uses NGAAvailabilityDetails::setTechnologyMessages()
     * @uses NGAAvailabilityDetails::setTelephoneNumber()
     * @param \ArrayType\ArrayOfServiceInfo $existingServicesDetails
     * @param \StructType\FTTCInfo $fTTCAvailability
     * @param \StructType\FTTCInfo $fTTCGfastAvailability
     * @param string $goldAddressKey
     * @param \StructType\FTTCObservedSyncSpeedType $observedSyncSpeedGFast
     * @param \StructType\LLUObservedSyncSpeedType $observedSyncSpeedLLU
     * @param \StructType\FTTCObservedSyncSpeedType $observedSyncSpeedVDSL
     * @param \ArrayType\ArrayOfOpenOrderInfo $openOrderDetails
     * @param string $postcode
     * @param \StructType\PostcodeMatchInfo $postcodeMatch
     * @param \StructType\RAGPercentageCoverage $postcodeRAGCoverage
     * @param \ArrayType\ArrayOfNGAProductMessage $productMessages
     * @param string $serviceIncompatibility
     * @param \ArrayType\ArrayOfTechnologyMessage $technologyMessages
     * @param string $telephoneNumber
     */
    public function __construct(\ArrayType\ArrayOfServiceInfo $existingServicesDetails = null, \StructType\FTTCInfo $fTTCAvailability = null, \StructType\FTTCInfo $fTTCGfastAvailability = null, $goldAddressKey = null, \StructType\FTTCObservedSyncSpeedType $observedSyncSpeedGFast = null, \StructType\LLUObservedSyncSpeedType $observedSyncSpeedLLU = null, \StructType\FTTCObservedSyncSpeedType $observedSyncSpeedVDSL = null, \ArrayType\ArrayOfOpenOrderInfo $openOrderDetails = null, $postcode = null, \StructType\PostcodeMatchInfo $postcodeMatch = null, \StructType\RAGPercentageCoverage $postcodeRAGCoverage = null, \ArrayType\ArrayOfNGAProductMessage $productMessages = null, $serviceIncompatibility = null, \ArrayType\ArrayOfTechnologyMessage $technologyMessages = null, $telephoneNumber = null)
    {
        $this
            ->setExistingServicesDetails($existingServicesDetails)
            ->setFTTCAvailability($fTTCAvailability)
            ->setFTTCGfastAvailability($fTTCGfastAvailability)
            ->setGoldAddressKey($goldAddressKey)
            ->setObservedSyncSpeedGFast($observedSyncSpeedGFast)
            ->setObservedSyncSpeedLLU($observedSyncSpeedLLU)
            ->setObservedSyncSpeedVDSL($observedSyncSpeedVDSL)
            ->setOpenOrderDetails($openOrderDetails)
            ->setPostcode($postcode)
            ->setPostcodeMatch($postcodeMatch)
            ->setPostcodeRAGCoverage($postcodeRAGCoverage)
            ->setProductMessages($productMessages)
            ->setServiceIncompatibility($serviceIncompatibility)
            ->setTechnologyMessages($technologyMessages)
            ->setTelephoneNumber($telephoneNumber);
    }
    /**
     * Get ExistingServicesDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServiceInfo|null
     */
    public function getExistingServicesDetails()
    {
        return isset($this->ExistingServicesDetails) ? $this->ExistingServicesDetails : null;
    }
    /**
     * Set ExistingServicesDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServiceInfo $existingServicesDetails
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setExistingServicesDetails(\ArrayType\ArrayOfServiceInfo $existingServicesDetails = null)
    {
        if (is_null($existingServicesDetails) || (is_array($existingServicesDetails) && empty($existingServicesDetails))) {
            unset($this->ExistingServicesDetails);
        } else {
            $this->ExistingServicesDetails = $existingServicesDetails;
        }
        return $this;
    }
    /**
     * Get FTTCAvailability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FTTCInfo|null
     */
    public function getFTTCAvailability()
    {
        return isset($this->FTTCAvailability) ? $this->FTTCAvailability : null;
    }
    /**
     * Set FTTCAvailability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FTTCInfo $fTTCAvailability
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setFTTCAvailability(\StructType\FTTCInfo $fTTCAvailability = null)
    {
        if (is_null($fTTCAvailability) || (is_array($fTTCAvailability) && empty($fTTCAvailability))) {
            unset($this->FTTCAvailability);
        } else {
            $this->FTTCAvailability = $fTTCAvailability;
        }
        return $this;
    }
    /**
     * Get FTTCGfastAvailability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FTTCInfo|null
     */
    public function getFTTCGfastAvailability()
    {
        return isset($this->FTTCGfastAvailability) ? $this->FTTCGfastAvailability : null;
    }
    /**
     * Set FTTCGfastAvailability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FTTCInfo $fTTCGfastAvailability
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setFTTCGfastAvailability(\StructType\FTTCInfo $fTTCGfastAvailability = null)
    {
        if (is_null($fTTCGfastAvailability) || (is_array($fTTCGfastAvailability) && empty($fTTCGfastAvailability))) {
            unset($this->FTTCGfastAvailability);
        } else {
            $this->FTTCGfastAvailability = $fTTCGfastAvailability;
        }
        return $this;
    }
    /**
     * Get GoldAddressKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGoldAddressKey()
    {
        return isset($this->GoldAddressKey) ? $this->GoldAddressKey : null;
    }
    /**
     * Set GoldAddressKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $goldAddressKey
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setGoldAddressKey($goldAddressKey = null)
    {
        // validation for constraint: string
        if (!is_null($goldAddressKey) && !is_string($goldAddressKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goldAddressKey)), __LINE__);
        }
        if (is_null($goldAddressKey) || (is_array($goldAddressKey) && empty($goldAddressKey))) {
            unset($this->GoldAddressKey);
        } else {
            $this->GoldAddressKey = $goldAddressKey;
        }
        return $this;
    }
    /**
     * Get ObservedSyncSpeedGFast value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FTTCObservedSyncSpeedType|null
     */
    public function getObservedSyncSpeedGFast()
    {
        return isset($this->ObservedSyncSpeedGFast) ? $this->ObservedSyncSpeedGFast : null;
    }
    /**
     * Set ObservedSyncSpeedGFast value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FTTCObservedSyncSpeedType $observedSyncSpeedGFast
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setObservedSyncSpeedGFast(\StructType\FTTCObservedSyncSpeedType $observedSyncSpeedGFast = null)
    {
        if (is_null($observedSyncSpeedGFast) || (is_array($observedSyncSpeedGFast) && empty($observedSyncSpeedGFast))) {
            unset($this->ObservedSyncSpeedGFast);
        } else {
            $this->ObservedSyncSpeedGFast = $observedSyncSpeedGFast;
        }
        return $this;
    }
    /**
     * Get ObservedSyncSpeedLLU value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LLUObservedSyncSpeedType|null
     */
    public function getObservedSyncSpeedLLU()
    {
        return isset($this->ObservedSyncSpeedLLU) ? $this->ObservedSyncSpeedLLU : null;
    }
    /**
     * Set ObservedSyncSpeedLLU value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LLUObservedSyncSpeedType $observedSyncSpeedLLU
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setObservedSyncSpeedLLU(\StructType\LLUObservedSyncSpeedType $observedSyncSpeedLLU = null)
    {
        if (is_null($observedSyncSpeedLLU) || (is_array($observedSyncSpeedLLU) && empty($observedSyncSpeedLLU))) {
            unset($this->ObservedSyncSpeedLLU);
        } else {
            $this->ObservedSyncSpeedLLU = $observedSyncSpeedLLU;
        }
        return $this;
    }
    /**
     * Get ObservedSyncSpeedVDSL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FTTCObservedSyncSpeedType|null
     */
    public function getObservedSyncSpeedVDSL()
    {
        return isset($this->ObservedSyncSpeedVDSL) ? $this->ObservedSyncSpeedVDSL : null;
    }
    /**
     * Set ObservedSyncSpeedVDSL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FTTCObservedSyncSpeedType $observedSyncSpeedVDSL
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setObservedSyncSpeedVDSL(\StructType\FTTCObservedSyncSpeedType $observedSyncSpeedVDSL = null)
    {
        if (is_null($observedSyncSpeedVDSL) || (is_array($observedSyncSpeedVDSL) && empty($observedSyncSpeedVDSL))) {
            unset($this->ObservedSyncSpeedVDSL);
        } else {
            $this->ObservedSyncSpeedVDSL = $observedSyncSpeedVDSL;
        }
        return $this;
    }
    /**
     * Get OpenOrderDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOpenOrderInfo|null
     */
    public function getOpenOrderDetails()
    {
        return isset($this->OpenOrderDetails) ? $this->OpenOrderDetails : null;
    }
    /**
     * Set OpenOrderDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOpenOrderInfo $openOrderDetails
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setOpenOrderDetails(\ArrayType\ArrayOfOpenOrderInfo $openOrderDetails = null)
    {
        if (is_null($openOrderDetails) || (is_array($openOrderDetails) && empty($openOrderDetails))) {
            unset($this->OpenOrderDetails);
        } else {
            $this->OpenOrderDetails = $openOrderDetails;
        }
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get PostcodeMatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PostcodeMatchInfo|null
     */
    public function getPostcodeMatch()
    {
        return isset($this->PostcodeMatch) ? $this->PostcodeMatch : null;
    }
    /**
     * Set PostcodeMatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PostcodeMatchInfo $postcodeMatch
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setPostcodeMatch(\StructType\PostcodeMatchInfo $postcodeMatch = null)
    {
        if (is_null($postcodeMatch) || (is_array($postcodeMatch) && empty($postcodeMatch))) {
            unset($this->PostcodeMatch);
        } else {
            $this->PostcodeMatch = $postcodeMatch;
        }
        return $this;
    }
    /**
     * Get PostcodeRAGCoverage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RAGPercentageCoverage|null
     */
    public function getPostcodeRAGCoverage()
    {
        return isset($this->PostcodeRAGCoverage) ? $this->PostcodeRAGCoverage : null;
    }
    /**
     * Set PostcodeRAGCoverage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RAGPercentageCoverage $postcodeRAGCoverage
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setPostcodeRAGCoverage(\StructType\RAGPercentageCoverage $postcodeRAGCoverage = null)
    {
        if (is_null($postcodeRAGCoverage) || (is_array($postcodeRAGCoverage) && empty($postcodeRAGCoverage))) {
            unset($this->PostcodeRAGCoverage);
        } else {
            $this->PostcodeRAGCoverage = $postcodeRAGCoverage;
        }
        return $this;
    }
    /**
     * Get ProductMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNGAProductMessage|null
     */
    public function getProductMessages()
    {
        return isset($this->ProductMessages) ? $this->ProductMessages : null;
    }
    /**
     * Set ProductMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNGAProductMessage $productMessages
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setProductMessages(\ArrayType\ArrayOfNGAProductMessage $productMessages = null)
    {
        if (is_null($productMessages) || (is_array($productMessages) && empty($productMessages))) {
            unset($this->ProductMessages);
        } else {
            $this->ProductMessages = $productMessages;
        }
        return $this;
    }
    /**
     * Get ServiceIncompatibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceIncompatibility()
    {
        return isset($this->ServiceIncompatibility) ? $this->ServiceIncompatibility : null;
    }
    /**
     * Set ServiceIncompatibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceIncompatibility
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setServiceIncompatibility($serviceIncompatibility = null)
    {
        // validation for constraint: string
        if (!is_null($serviceIncompatibility) && !is_string($serviceIncompatibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceIncompatibility)), __LINE__);
        }
        if (is_null($serviceIncompatibility) || (is_array($serviceIncompatibility) && empty($serviceIncompatibility))) {
            unset($this->ServiceIncompatibility);
        } else {
            $this->ServiceIncompatibility = $serviceIncompatibility;
        }
        return $this;
    }
    /**
     * Get TechnologyMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTechnologyMessage|null
     */
    public function getTechnologyMessages()
    {
        return isset($this->TechnologyMessages) ? $this->TechnologyMessages : null;
    }
    /**
     * Set TechnologyMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTechnologyMessage $technologyMessages
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setTechnologyMessages(\ArrayType\ArrayOfTechnologyMessage $technologyMessages = null)
    {
        if (is_null($technologyMessages) || (is_array($technologyMessages) && empty($technologyMessages))) {
            unset($this->TechnologyMessages);
        } else {
            $this->TechnologyMessages = $technologyMessages;
        }
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return isset($this->TelephoneNumber) ? $this->TelephoneNumber : null;
    }
    /**
     * Set TelephoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telephoneNumber
     * @return \StructType\NGAAvailabilityDetails
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        if (is_null($telephoneNumber) || (is_array($telephoneNumber) && empty($telephoneNumber))) {
            unset($this->TelephoneNumber);
        } else {
            $this->TelephoneNumber = $telephoneNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NGAAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
