<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FTTPAvailabilityDetails.FTTPAddressDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FTTPAvailabilityDetails.FTTPAddressDetails
 * @subpackage Structs
 */
class FTTPAvailabilityDetails_FTTPAddressDetails extends AbstractStructBase
{
    /**
     * The AdditionalInformationDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdditionalInformation
     */
    public $AdditionalInformationDetails;
    /**
     * The BuildingName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuildingName;
    /**
     * The BuildingNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuildingNumber;
    /**
     * The CabinetID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinetID;
    /**
     * The DependentThoroughfare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DependentThoroughfare;
    /**
     * The EstimatedThroughputSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfThroughputSpeedType
     */
    public $EstimatedThroughputSpeed;
    /**
     * The FTTPCapacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FTTPCapacity;
    /**
     * The FTTPReason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FTTPReason;
    /**
     * The FTTPStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FTTPStatus;
    /**
     * The InstallType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallType;
    /**
     * The Locality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Locality;
    /**
     * The OpenOrders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrdersInformation
     */
    public $OpenOrders;
    /**
     * The OrganisationName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganisationName;
    /**
     * The POPSiteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $POPSiteID;
    /**
     * The PlannedAvailableDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PlannedAvailableDate;
    /**
     * The PlannedTakeOrdersDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PlannedTakeOrdersDate;
    /**
     * The PostTown
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostTown;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Street;
    /**
     * The SubBuilding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubBuilding;
    /**
     * The UPRN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UPRN;
    /**
     * Constructor method for FTTPAvailabilityDetails.FTTPAddressDetails
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setAdditionalInformationDetails()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setBuildingName()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setBuildingNumber()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setCabinetID()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setDependentThoroughfare()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setEstimatedThroughputSpeed()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setFTTPCapacity()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setFTTPReason()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setFTTPStatus()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setInstallType()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setLocality()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setOpenOrders()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setOrganisationName()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setPOPSiteID()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setPlannedAvailableDate()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setPlannedTakeOrdersDate()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setPostTown()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setPostcode()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setStreet()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setSubBuilding()
     * @uses FTTPAvailabilityDetails_FTTPAddressDetails::setUPRN()
     * @param \ArrayType\ArrayOfAdditionalInformation $additionalInformationDetails
     * @param string $buildingName
     * @param string $buildingNumber
     * @param string $cabinetID
     * @param string $dependentThoroughfare
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed
     * @param string $fTTPCapacity
     * @param string $fTTPReason
     * @param string $fTTPStatus
     * @param string $installType
     * @param string $locality
     * @param \StructType\OrdersInformation $openOrders
     * @param string $organisationName
     * @param string $pOPSiteID
     * @param string $plannedAvailableDate
     * @param string $plannedTakeOrdersDate
     * @param string $postTown
     * @param string $postcode
     * @param string $street
     * @param string $subBuilding
     * @param int $uPRN
     */
    public function __construct(\ArrayType\ArrayOfAdditionalInformation $additionalInformationDetails = null, $buildingName = null, $buildingNumber = null, $cabinetID = null, $dependentThoroughfare = null, \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed = null, $fTTPCapacity = null, $fTTPReason = null, $fTTPStatus = null, $installType = null, $locality = null, \StructType\OrdersInformation $openOrders = null, $organisationName = null, $pOPSiteID = null, $plannedAvailableDate = null, $plannedTakeOrdersDate = null, $postTown = null, $postcode = null, $street = null, $subBuilding = null, $uPRN = null)
    {
        $this
            ->setAdditionalInformationDetails($additionalInformationDetails)
            ->setBuildingName($buildingName)
            ->setBuildingNumber($buildingNumber)
            ->setCabinetID($cabinetID)
            ->setDependentThoroughfare($dependentThoroughfare)
            ->setEstimatedThroughputSpeed($estimatedThroughputSpeed)
            ->setFTTPCapacity($fTTPCapacity)
            ->setFTTPReason($fTTPReason)
            ->setFTTPStatus($fTTPStatus)
            ->setInstallType($installType)
            ->setLocality($locality)
            ->setOpenOrders($openOrders)
            ->setOrganisationName($organisationName)
            ->setPOPSiteID($pOPSiteID)
            ->setPlannedAvailableDate($plannedAvailableDate)
            ->setPlannedTakeOrdersDate($plannedTakeOrdersDate)
            ->setPostTown($postTown)
            ->setPostcode($postcode)
            ->setStreet($street)
            ->setSubBuilding($subBuilding)
            ->setUPRN($uPRN);
    }
    /**
     * Get AdditionalInformationDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdditionalInformation|null
     */
    public function getAdditionalInformationDetails()
    {
        return isset($this->AdditionalInformationDetails) ? $this->AdditionalInformationDetails : null;
    }
    /**
     * Set AdditionalInformationDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdditionalInformation $additionalInformationDetails
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setAdditionalInformationDetails(\ArrayType\ArrayOfAdditionalInformation $additionalInformationDetails = null)
    {
        if (is_null($additionalInformationDetails) || (is_array($additionalInformationDetails) && empty($additionalInformationDetails))) {
            unset($this->AdditionalInformationDetails);
        } else {
            $this->AdditionalInformationDetails = $additionalInformationDetails;
        }
        return $this;
    }
    /**
     * Get BuildingName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuildingName()
    {
        return isset($this->BuildingName) ? $this->BuildingName : null;
    }
    /**
     * Set BuildingName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buildingName
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buildingName)), __LINE__);
        }
        if (is_null($buildingName) || (is_array($buildingName) && empty($buildingName))) {
            unset($this->BuildingName);
        } else {
            $this->BuildingName = $buildingName;
        }
        return $this;
    }
    /**
     * Get BuildingNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuildingNumber()
    {
        return isset($this->BuildingNumber) ? $this->BuildingNumber : null;
    }
    /**
     * Set BuildingNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buildingNumber
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setBuildingNumber($buildingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNumber) && !is_string($buildingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buildingNumber)), __LINE__);
        }
        if (is_null($buildingNumber) || (is_array($buildingNumber) && empty($buildingNumber))) {
            unset($this->BuildingNumber);
        } else {
            $this->BuildingNumber = $buildingNumber;
        }
        return $this;
    }
    /**
     * Get CabinetID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinetID()
    {
        return isset($this->CabinetID) ? $this->CabinetID : null;
    }
    /**
     * Set CabinetID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinetID
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setCabinetID($cabinetID = null)
    {
        // validation for constraint: string
        if (!is_null($cabinetID) && !is_string($cabinetID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinetID)), __LINE__);
        }
        if (is_null($cabinetID) || (is_array($cabinetID) && empty($cabinetID))) {
            unset($this->CabinetID);
        } else {
            $this->CabinetID = $cabinetID;
        }
        return $this;
    }
    /**
     * Get DependentThoroughfare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDependentThoroughfare()
    {
        return isset($this->DependentThoroughfare) ? $this->DependentThoroughfare : null;
    }
    /**
     * Set DependentThoroughfare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dependentThoroughfare
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setDependentThoroughfare($dependentThoroughfare = null)
    {
        // validation for constraint: string
        if (!is_null($dependentThoroughfare) && !is_string($dependentThoroughfare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dependentThoroughfare)), __LINE__);
        }
        if (is_null($dependentThoroughfare) || (is_array($dependentThoroughfare) && empty($dependentThoroughfare))) {
            unset($this->DependentThoroughfare);
        } else {
            $this->DependentThoroughfare = $dependentThoroughfare;
        }
        return $this;
    }
    /**
     * Get EstimatedThroughputSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfThroughputSpeedType|null
     */
    public function getEstimatedThroughputSpeed()
    {
        return isset($this->EstimatedThroughputSpeed) ? $this->EstimatedThroughputSpeed : null;
    }
    /**
     * Set EstimatedThroughputSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setEstimatedThroughputSpeed(\ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed = null)
    {
        if (is_null($estimatedThroughputSpeed) || (is_array($estimatedThroughputSpeed) && empty($estimatedThroughputSpeed))) {
            unset($this->EstimatedThroughputSpeed);
        } else {
            $this->EstimatedThroughputSpeed = $estimatedThroughputSpeed;
        }
        return $this;
    }
    /**
     * Get FTTPCapacity value
     * @return string|null
     */
    public function getFTTPCapacity()
    {
        return $this->FTTPCapacity;
    }
    /**
     * Set FTTPCapacity value
     * @uses \EnumType\FTTPCapacityEnum::valueIsValid()
     * @uses \EnumType\FTTPCapacityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fTTPCapacity
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setFTTPCapacity($fTTPCapacity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FTTPCapacityEnum::valueIsValid($fTTPCapacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fTTPCapacity, implode(', ', \EnumType\FTTPCapacityEnum::getValidValues())), __LINE__);
        }
        $this->FTTPCapacity = $fTTPCapacity;
        return $this;
    }
    /**
     * Get FTTPReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFTTPReason()
    {
        return isset($this->FTTPReason) ? $this->FTTPReason : null;
    }
    /**
     * Set FTTPReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fTTPReason
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setFTTPReason($fTTPReason = null)
    {
        // validation for constraint: string
        if (!is_null($fTTPReason) && !is_string($fTTPReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fTTPReason)), __LINE__);
        }
        if (is_null($fTTPReason) || (is_array($fTTPReason) && empty($fTTPReason))) {
            unset($this->FTTPReason);
        } else {
            $this->FTTPReason = $fTTPReason;
        }
        return $this;
    }
    /**
     * Get FTTPStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFTTPStatus()
    {
        return isset($this->FTTPStatus) ? $this->FTTPStatus : null;
    }
    /**
     * Set FTTPStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fTTPStatus
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setFTTPStatus($fTTPStatus = null)
    {
        // validation for constraint: string
        if (!is_null($fTTPStatus) && !is_string($fTTPStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fTTPStatus)), __LINE__);
        }
        if (is_null($fTTPStatus) || (is_array($fTTPStatus) && empty($fTTPStatus))) {
            unset($this->FTTPStatus);
        } else {
            $this->FTTPStatus = $fTTPStatus;
        }
        return $this;
    }
    /**
     * Get InstallType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallType()
    {
        return isset($this->InstallType) ? $this->InstallType : null;
    }
    /**
     * Set InstallType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installType
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setInstallType($installType = null)
    {
        // validation for constraint: string
        if (!is_null($installType) && !is_string($installType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installType)), __LINE__);
        }
        if (is_null($installType) || (is_array($installType) && empty($installType))) {
            unset($this->InstallType);
        } else {
            $this->InstallType = $installType;
        }
        return $this;
    }
    /**
     * Get Locality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocality()
    {
        return isset($this->Locality) ? $this->Locality : null;
    }
    /**
     * Set Locality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locality
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setLocality($locality = null)
    {
        // validation for constraint: string
        if (!is_null($locality) && !is_string($locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locality)), __LINE__);
        }
        if (is_null($locality) || (is_array($locality) && empty($locality))) {
            unset($this->Locality);
        } else {
            $this->Locality = $locality;
        }
        return $this;
    }
    /**
     * Get OpenOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrdersInformation|null
     */
    public function getOpenOrders()
    {
        return isset($this->OpenOrders) ? $this->OpenOrders : null;
    }
    /**
     * Set OpenOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OrdersInformation $openOrders
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setOpenOrders(\StructType\OrdersInformation $openOrders = null)
    {
        if (is_null($openOrders) || (is_array($openOrders) && empty($openOrders))) {
            unset($this->OpenOrders);
        } else {
            $this->OpenOrders = $openOrders;
        }
        return $this;
    }
    /**
     * Get OrganisationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganisationName()
    {
        return isset($this->OrganisationName) ? $this->OrganisationName : null;
    }
    /**
     * Set OrganisationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organisationName
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setOrganisationName($organisationName = null)
    {
        // validation for constraint: string
        if (!is_null($organisationName) && !is_string($organisationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationName)), __LINE__);
        }
        if (is_null($organisationName) || (is_array($organisationName) && empty($organisationName))) {
            unset($this->OrganisationName);
        } else {
            $this->OrganisationName = $organisationName;
        }
        return $this;
    }
    /**
     * Get POPSiteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPOPSiteID()
    {
        return isset($this->POPSiteID) ? $this->POPSiteID : null;
    }
    /**
     * Set POPSiteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pOPSiteID
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setPOPSiteID($pOPSiteID = null)
    {
        // validation for constraint: string
        if (!is_null($pOPSiteID) && !is_string($pOPSiteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pOPSiteID)), __LINE__);
        }
        if (is_null($pOPSiteID) || (is_array($pOPSiteID) && empty($pOPSiteID))) {
            unset($this->POPSiteID);
        } else {
            $this->POPSiteID = $pOPSiteID;
        }
        return $this;
    }
    /**
     * Get PlannedAvailableDate value
     * @return string|null
     */
    public function getPlannedAvailableDate()
    {
        return $this->PlannedAvailableDate;
    }
    /**
     * Set PlannedAvailableDate value
     * @param string $plannedAvailableDate
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setPlannedAvailableDate($plannedAvailableDate = null)
    {
        // validation for constraint: string
        if (!is_null($plannedAvailableDate) && !is_string($plannedAvailableDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plannedAvailableDate)), __LINE__);
        }
        $this->PlannedAvailableDate = $plannedAvailableDate;
        return $this;
    }
    /**
     * Get PlannedTakeOrdersDate value
     * @return string|null
     */
    public function getPlannedTakeOrdersDate()
    {
        return $this->PlannedTakeOrdersDate;
    }
    /**
     * Set PlannedTakeOrdersDate value
     * @param string $plannedTakeOrdersDate
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setPlannedTakeOrdersDate($plannedTakeOrdersDate = null)
    {
        // validation for constraint: string
        if (!is_null($plannedTakeOrdersDate) && !is_string($plannedTakeOrdersDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plannedTakeOrdersDate)), __LINE__);
        }
        $this->PlannedTakeOrdersDate = $plannedTakeOrdersDate;
        return $this;
    }
    /**
     * Get PostTown value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostTown()
    {
        return isset($this->PostTown) ? $this->PostTown : null;
    }
    /**
     * Set PostTown value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postTown
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setPostTown($postTown = null)
    {
        // validation for constraint: string
        if (!is_null($postTown) && !is_string($postTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postTown)), __LINE__);
        }
        if (is_null($postTown) || (is_array($postTown) && empty($postTown))) {
            unset($this->PostTown);
        } else {
            $this->PostTown = $postTown;
        }
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get Street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->Street) ? $this->Street : null;
    }
    /**
     * Set Street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->Street);
        } else {
            $this->Street = $street;
        }
        return $this;
    }
    /**
     * Get SubBuilding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubBuilding()
    {
        return isset($this->SubBuilding) ? $this->SubBuilding : null;
    }
    /**
     * Set SubBuilding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subBuilding
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setSubBuilding($subBuilding = null)
    {
        // validation for constraint: string
        if (!is_null($subBuilding) && !is_string($subBuilding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subBuilding)), __LINE__);
        }
        if (is_null($subBuilding) || (is_array($subBuilding) && empty($subBuilding))) {
            unset($this->SubBuilding);
        } else {
            $this->SubBuilding = $subBuilding;
        }
        return $this;
    }
    /**
     * Get UPRN value
     * @return int|null
     */
    public function getUPRN()
    {
        return $this->UPRN;
    }
    /**
     * Set UPRN value
     * @param int $uPRN
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public function setUPRN($uPRN = null)
    {
        // validation for constraint: int
        if (!is_null($uPRN) && !is_numeric($uPRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uPRN)), __LINE__);
        }
        $this->UPRN = $uPRN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FTTPAvailabilityDetails_FTTPAddressDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
