<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FTTCInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FTTCInfo
 * @subpackage Structs
 */
class FTTCInfo extends AbstractStructBase
{
    /**
     * The Bandwidth18x2ProvideAvailable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Bandwidth18x2ProvideAvailable;
    /**
     * The Bandwidth18x2SIMAvailable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Bandwidth18x2SIMAvailable;
    /**
     * The CurrentInstallType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentInstallType;
    /**
     * The EstimatedSyncSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FTTCSyncSpeedType
     */
    public $EstimatedSyncSpeed;
    /**
     * The EstimatedThroughputSpeedRangeA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfThroughputSpeedType
     */
    public $EstimatedThroughputSpeedRangeA;
    /**
     * The EstimatedThroughputSpeedRangeB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfThroughputSpeedType
     */
    public $EstimatedThroughputSpeedRangeB;
    /**
     * The ExchangeDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNGAExchangeInfo
     */
    public $ExchangeDetails;
    /**
     * The FTTCAvailability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FTTCAvailability;
    /**
     * The FTTCAvailableMI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FTTCAvailableMI;
    /**
     * The FTTCAvailableSI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FTTCAvailableSI;
    /**
     * The FTTCOpenreachAvailable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FTTCOpenreachAvailable;
    /**
     * The FTTCOpenreachAvailableDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FTTCOpenreachAvailableDate;
    /**
     * The PCPID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PCPID;
    /**
     * Constructor method for FTTCInfo
     * @uses FTTCInfo::setBandwidth18x2ProvideAvailable()
     * @uses FTTCInfo::setBandwidth18x2SIMAvailable()
     * @uses FTTCInfo::setCurrentInstallType()
     * @uses FTTCInfo::setEstimatedSyncSpeed()
     * @uses FTTCInfo::setEstimatedThroughputSpeedRangeA()
     * @uses FTTCInfo::setEstimatedThroughputSpeedRangeB()
     * @uses FTTCInfo::setExchangeDetails()
     * @uses FTTCInfo::setFTTCAvailability()
     * @uses FTTCInfo::setFTTCAvailableMI()
     * @uses FTTCInfo::setFTTCAvailableSI()
     * @uses FTTCInfo::setFTTCOpenreachAvailable()
     * @uses FTTCInfo::setFTTCOpenreachAvailableDate()
     * @uses FTTCInfo::setPCPID()
     * @param string $bandwidth18x2ProvideAvailable
     * @param string $bandwidth18x2SIMAvailable
     * @param string $currentInstallType
     * @param \StructType\FTTCSyncSpeedType $estimatedSyncSpeed
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedRangeA
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedRangeB
     * @param \ArrayType\ArrayOfNGAExchangeInfo $exchangeDetails
     * @param string $fTTCAvailability
     * @param string $fTTCAvailableMI
     * @param string $fTTCAvailableSI
     * @param string $fTTCOpenreachAvailable
     * @param string $fTTCOpenreachAvailableDate
     * @param string $pCPID
     */
    public function __construct($bandwidth18x2ProvideAvailable = null, $bandwidth18x2SIMAvailable = null, $currentInstallType = null, \StructType\FTTCSyncSpeedType $estimatedSyncSpeed = null, \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedRangeA = null, \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedRangeB = null, \ArrayType\ArrayOfNGAExchangeInfo $exchangeDetails = null, $fTTCAvailability = null, $fTTCAvailableMI = null, $fTTCAvailableSI = null, $fTTCOpenreachAvailable = null, $fTTCOpenreachAvailableDate = null, $pCPID = null)
    {
        $this
            ->setBandwidth18x2ProvideAvailable($bandwidth18x2ProvideAvailable)
            ->setBandwidth18x2SIMAvailable($bandwidth18x2SIMAvailable)
            ->setCurrentInstallType($currentInstallType)
            ->setEstimatedSyncSpeed($estimatedSyncSpeed)
            ->setEstimatedThroughputSpeedRangeA($estimatedThroughputSpeedRangeA)
            ->setEstimatedThroughputSpeedRangeB($estimatedThroughputSpeedRangeB)
            ->setExchangeDetails($exchangeDetails)
            ->setFTTCAvailability($fTTCAvailability)
            ->setFTTCAvailableMI($fTTCAvailableMI)
            ->setFTTCAvailableSI($fTTCAvailableSI)
            ->setFTTCOpenreachAvailable($fTTCOpenreachAvailable)
            ->setFTTCOpenreachAvailableDate($fTTCOpenreachAvailableDate)
            ->setPCPID($pCPID);
    }
    /**
     * Get Bandwidth18x2ProvideAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBandwidth18x2ProvideAvailable()
    {
        return isset($this->Bandwidth18x2ProvideAvailable) ? $this->Bandwidth18x2ProvideAvailable : null;
    }
    /**
     * Set Bandwidth18x2ProvideAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bandwidth18x2ProvideAvailable
     * @return \StructType\FTTCInfo
     */
    public function setBandwidth18x2ProvideAvailable($bandwidth18x2ProvideAvailable = null)
    {
        // validation for constraint: string
        if (!is_null($bandwidth18x2ProvideAvailable) && !is_string($bandwidth18x2ProvideAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bandwidth18x2ProvideAvailable)), __LINE__);
        }
        if (is_null($bandwidth18x2ProvideAvailable) || (is_array($bandwidth18x2ProvideAvailable) && empty($bandwidth18x2ProvideAvailable))) {
            unset($this->Bandwidth18x2ProvideAvailable);
        } else {
            $this->Bandwidth18x2ProvideAvailable = $bandwidth18x2ProvideAvailable;
        }
        return $this;
    }
    /**
     * Get Bandwidth18x2SIMAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBandwidth18x2SIMAvailable()
    {
        return isset($this->Bandwidth18x2SIMAvailable) ? $this->Bandwidth18x2SIMAvailable : null;
    }
    /**
     * Set Bandwidth18x2SIMAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bandwidth18x2SIMAvailable
     * @return \StructType\FTTCInfo
     */
    public function setBandwidth18x2SIMAvailable($bandwidth18x2SIMAvailable = null)
    {
        // validation for constraint: string
        if (!is_null($bandwidth18x2SIMAvailable) && !is_string($bandwidth18x2SIMAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bandwidth18x2SIMAvailable)), __LINE__);
        }
        if (is_null($bandwidth18x2SIMAvailable) || (is_array($bandwidth18x2SIMAvailable) && empty($bandwidth18x2SIMAvailable))) {
            unset($this->Bandwidth18x2SIMAvailable);
        } else {
            $this->Bandwidth18x2SIMAvailable = $bandwidth18x2SIMAvailable;
        }
        return $this;
    }
    /**
     * Get CurrentInstallType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentInstallType()
    {
        return isset($this->CurrentInstallType) ? $this->CurrentInstallType : null;
    }
    /**
     * Set CurrentInstallType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentInstallType
     * @return \StructType\FTTCInfo
     */
    public function setCurrentInstallType($currentInstallType = null)
    {
        // validation for constraint: string
        if (!is_null($currentInstallType) && !is_string($currentInstallType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentInstallType)), __LINE__);
        }
        if (is_null($currentInstallType) || (is_array($currentInstallType) && empty($currentInstallType))) {
            unset($this->CurrentInstallType);
        } else {
            $this->CurrentInstallType = $currentInstallType;
        }
        return $this;
    }
    /**
     * Get EstimatedSyncSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FTTCSyncSpeedType|null
     */
    public function getEstimatedSyncSpeed()
    {
        return isset($this->EstimatedSyncSpeed) ? $this->EstimatedSyncSpeed : null;
    }
    /**
     * Set EstimatedSyncSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FTTCSyncSpeedType $estimatedSyncSpeed
     * @return \StructType\FTTCInfo
     */
    public function setEstimatedSyncSpeed(\StructType\FTTCSyncSpeedType $estimatedSyncSpeed = null)
    {
        if (is_null($estimatedSyncSpeed) || (is_array($estimatedSyncSpeed) && empty($estimatedSyncSpeed))) {
            unset($this->EstimatedSyncSpeed);
        } else {
            $this->EstimatedSyncSpeed = $estimatedSyncSpeed;
        }
        return $this;
    }
    /**
     * Get EstimatedThroughputSpeedRangeA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfThroughputSpeedType|null
     */
    public function getEstimatedThroughputSpeedRangeA()
    {
        return isset($this->EstimatedThroughputSpeedRangeA) ? $this->EstimatedThroughputSpeedRangeA : null;
    }
    /**
     * Set EstimatedThroughputSpeedRangeA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedRangeA
     * @return \StructType\FTTCInfo
     */
    public function setEstimatedThroughputSpeedRangeA(\ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedRangeA = null)
    {
        if (is_null($estimatedThroughputSpeedRangeA) || (is_array($estimatedThroughputSpeedRangeA) && empty($estimatedThroughputSpeedRangeA))) {
            unset($this->EstimatedThroughputSpeedRangeA);
        } else {
            $this->EstimatedThroughputSpeedRangeA = $estimatedThroughputSpeedRangeA;
        }
        return $this;
    }
    /**
     * Get EstimatedThroughputSpeedRangeB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfThroughputSpeedType|null
     */
    public function getEstimatedThroughputSpeedRangeB()
    {
        return isset($this->EstimatedThroughputSpeedRangeB) ? $this->EstimatedThroughputSpeedRangeB : null;
    }
    /**
     * Set EstimatedThroughputSpeedRangeB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedRangeB
     * @return \StructType\FTTCInfo
     */
    public function setEstimatedThroughputSpeedRangeB(\ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeedRangeB = null)
    {
        if (is_null($estimatedThroughputSpeedRangeB) || (is_array($estimatedThroughputSpeedRangeB) && empty($estimatedThroughputSpeedRangeB))) {
            unset($this->EstimatedThroughputSpeedRangeB);
        } else {
            $this->EstimatedThroughputSpeedRangeB = $estimatedThroughputSpeedRangeB;
        }
        return $this;
    }
    /**
     * Get ExchangeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNGAExchangeInfo|null
     */
    public function getExchangeDetails()
    {
        return isset($this->ExchangeDetails) ? $this->ExchangeDetails : null;
    }
    /**
     * Set ExchangeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNGAExchangeInfo $exchangeDetails
     * @return \StructType\FTTCInfo
     */
    public function setExchangeDetails(\ArrayType\ArrayOfNGAExchangeInfo $exchangeDetails = null)
    {
        if (is_null($exchangeDetails) || (is_array($exchangeDetails) && empty($exchangeDetails))) {
            unset($this->ExchangeDetails);
        } else {
            $this->ExchangeDetails = $exchangeDetails;
        }
        return $this;
    }
    /**
     * Get FTTCAvailability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFTTCAvailability()
    {
        return isset($this->FTTCAvailability) ? $this->FTTCAvailability : null;
    }
    /**
     * Set FTTCAvailability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fTTCAvailability
     * @return \StructType\FTTCInfo
     */
    public function setFTTCAvailability($fTTCAvailability = null)
    {
        // validation for constraint: string
        if (!is_null($fTTCAvailability) && !is_string($fTTCAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fTTCAvailability)), __LINE__);
        }
        if (is_null($fTTCAvailability) || (is_array($fTTCAvailability) && empty($fTTCAvailability))) {
            unset($this->FTTCAvailability);
        } else {
            $this->FTTCAvailability = $fTTCAvailability;
        }
        return $this;
    }
    /**
     * Get FTTCAvailableMI value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFTTCAvailableMI()
    {
        return isset($this->FTTCAvailableMI) ? $this->FTTCAvailableMI : null;
    }
    /**
     * Set FTTCAvailableMI value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fTTCAvailableMI
     * @return \StructType\FTTCInfo
     */
    public function setFTTCAvailableMI($fTTCAvailableMI = null)
    {
        // validation for constraint: string
        if (!is_null($fTTCAvailableMI) && !is_string($fTTCAvailableMI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fTTCAvailableMI)), __LINE__);
        }
        if (is_null($fTTCAvailableMI) || (is_array($fTTCAvailableMI) && empty($fTTCAvailableMI))) {
            unset($this->FTTCAvailableMI);
        } else {
            $this->FTTCAvailableMI = $fTTCAvailableMI;
        }
        return $this;
    }
    /**
     * Get FTTCAvailableSI value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFTTCAvailableSI()
    {
        return isset($this->FTTCAvailableSI) ? $this->FTTCAvailableSI : null;
    }
    /**
     * Set FTTCAvailableSI value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fTTCAvailableSI
     * @return \StructType\FTTCInfo
     */
    public function setFTTCAvailableSI($fTTCAvailableSI = null)
    {
        // validation for constraint: string
        if (!is_null($fTTCAvailableSI) && !is_string($fTTCAvailableSI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fTTCAvailableSI)), __LINE__);
        }
        if (is_null($fTTCAvailableSI) || (is_array($fTTCAvailableSI) && empty($fTTCAvailableSI))) {
            unset($this->FTTCAvailableSI);
        } else {
            $this->FTTCAvailableSI = $fTTCAvailableSI;
        }
        return $this;
    }
    /**
     * Get FTTCOpenreachAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFTTCOpenreachAvailable()
    {
        return isset($this->FTTCOpenreachAvailable) ? $this->FTTCOpenreachAvailable : null;
    }
    /**
     * Set FTTCOpenreachAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fTTCOpenreachAvailable
     * @return \StructType\FTTCInfo
     */
    public function setFTTCOpenreachAvailable($fTTCOpenreachAvailable = null)
    {
        // validation for constraint: string
        if (!is_null($fTTCOpenreachAvailable) && !is_string($fTTCOpenreachAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fTTCOpenreachAvailable)), __LINE__);
        }
        if (is_null($fTTCOpenreachAvailable) || (is_array($fTTCOpenreachAvailable) && empty($fTTCOpenreachAvailable))) {
            unset($this->FTTCOpenreachAvailable);
        } else {
            $this->FTTCOpenreachAvailable = $fTTCOpenreachAvailable;
        }
        return $this;
    }
    /**
     * Get FTTCOpenreachAvailableDate value
     * @return string|null
     */
    public function getFTTCOpenreachAvailableDate()
    {
        return $this->FTTCOpenreachAvailableDate;
    }
    /**
     * Set FTTCOpenreachAvailableDate value
     * @param string $fTTCOpenreachAvailableDate
     * @return \StructType\FTTCInfo
     */
    public function setFTTCOpenreachAvailableDate($fTTCOpenreachAvailableDate = null)
    {
        // validation for constraint: string
        if (!is_null($fTTCOpenreachAvailableDate) && !is_string($fTTCOpenreachAvailableDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fTTCOpenreachAvailableDate)), __LINE__);
        }
        $this->FTTCOpenreachAvailableDate = $fTTCOpenreachAvailableDate;
        return $this;
    }
    /**
     * Get PCPID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPCPID()
    {
        return isset($this->PCPID) ? $this->PCPID : null;
    }
    /**
     * Set PCPID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pCPID
     * @return \StructType\FTTCInfo
     */
    public function setPCPID($pCPID = null)
    {
        // validation for constraint: string
        if (!is_null($pCPID) && !is_string($pCPID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pCPID)), __LINE__);
        }
        if (is_null($pCPID) || (is_array($pCPID) && empty($pCPID))) {
            unset($this->PCPID);
        } else {
            $this->PCPID = $pCPID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FTTCInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
