<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EDFAAvailability StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EDFAAvailability
 * @subpackage Structs
 */
class EDFAAvailability extends AbstractStructBase
{
    /**
     * The CollectorNodeExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectorNodeExchangeCode;
    /**
     * The CollectorNodeExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectorNodeExchangeName;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Distance;
    /**
     * The EDFABandwidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $EDFABandwidth;
    /**
     * The EDFASubType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EDFASubType;
    /**
     * The FibreExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FibreExchangeCode;
    /**
     * The FibreExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FibreExchangeName;
    /**
     * The IndicativeECC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndicativeECC;
    /**
     * The IndicativeOrderCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndicativeOrderCategory;
    /**
     * The LocalExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalExchangeCode;
    /**
     * The LocalExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalExchangeName;
    /**
     * The ORLeadTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ORLeadTime;
    /**
     * The OrderCategoryExplanation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderCategoryExplanation;
    /**
     * The ResilienceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReslilienceInformationResult
     */
    public $ResilienceInformation;
    /**
     * The TTLeadTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TTLeadTime;
    /**
     * The Zone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zone;
    /**
     * Constructor method for EDFAAvailability
     * @uses EDFAAvailability::setCollectorNodeExchangeCode()
     * @uses EDFAAvailability::setCollectorNodeExchangeName()
     * @uses EDFAAvailability::setDistance()
     * @uses EDFAAvailability::setEDFABandwidth()
     * @uses EDFAAvailability::setEDFASubType()
     * @uses EDFAAvailability::setFibreExchangeCode()
     * @uses EDFAAvailability::setFibreExchangeName()
     * @uses EDFAAvailability::setIndicativeECC()
     * @uses EDFAAvailability::setIndicativeOrderCategory()
     * @uses EDFAAvailability::setLocalExchangeCode()
     * @uses EDFAAvailability::setLocalExchangeName()
     * @uses EDFAAvailability::setORLeadTime()
     * @uses EDFAAvailability::setOrderCategoryExplanation()
     * @uses EDFAAvailability::setResilienceInformation()
     * @uses EDFAAvailability::setTTLeadTime()
     * @uses EDFAAvailability::setZone()
     * @param string $collectorNodeExchangeCode
     * @param string $collectorNodeExchangeName
     * @param int $distance
     * @param \ArrayType\ArrayOfstring $eDFABandwidth
     * @param string $eDFASubType
     * @param string $fibreExchangeCode
     * @param string $fibreExchangeName
     * @param string $indicativeECC
     * @param string $indicativeOrderCategory
     * @param string $localExchangeCode
     * @param string $localExchangeName
     * @param string $oRLeadTime
     * @param string $orderCategoryExplanation
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @param string $tTLeadTime
     * @param string $zone
     */
    public function __construct($collectorNodeExchangeCode = null, $collectorNodeExchangeName = null, $distance = null, \ArrayType\ArrayOfstring $eDFABandwidth = null, $eDFASubType = null, $fibreExchangeCode = null, $fibreExchangeName = null, $indicativeECC = null, $indicativeOrderCategory = null, $localExchangeCode = null, $localExchangeName = null, $oRLeadTime = null, $orderCategoryExplanation = null, \StructType\ReslilienceInformationResult $resilienceInformation = null, $tTLeadTime = null, $zone = null)
    {
        $this
            ->setCollectorNodeExchangeCode($collectorNodeExchangeCode)
            ->setCollectorNodeExchangeName($collectorNodeExchangeName)
            ->setDistance($distance)
            ->setEDFABandwidth($eDFABandwidth)
            ->setEDFASubType($eDFASubType)
            ->setFibreExchangeCode($fibreExchangeCode)
            ->setFibreExchangeName($fibreExchangeName)
            ->setIndicativeECC($indicativeECC)
            ->setIndicativeOrderCategory($indicativeOrderCategory)
            ->setLocalExchangeCode($localExchangeCode)
            ->setLocalExchangeName($localExchangeName)
            ->setORLeadTime($oRLeadTime)
            ->setOrderCategoryExplanation($orderCategoryExplanation)
            ->setResilienceInformation($resilienceInformation)
            ->setTTLeadTime($tTLeadTime)
            ->setZone($zone);
    }
    /**
     * Get CollectorNodeExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectorNodeExchangeCode()
    {
        return isset($this->CollectorNodeExchangeCode) ? $this->CollectorNodeExchangeCode : null;
    }
    /**
     * Set CollectorNodeExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectorNodeExchangeCode
     * @return \StructType\EDFAAvailability
     */
    public function setCollectorNodeExchangeCode($collectorNodeExchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($collectorNodeExchangeCode) && !is_string($collectorNodeExchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectorNodeExchangeCode)), __LINE__);
        }
        if (is_null($collectorNodeExchangeCode) || (is_array($collectorNodeExchangeCode) && empty($collectorNodeExchangeCode))) {
            unset($this->CollectorNodeExchangeCode);
        } else {
            $this->CollectorNodeExchangeCode = $collectorNodeExchangeCode;
        }
        return $this;
    }
    /**
     * Get CollectorNodeExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectorNodeExchangeName()
    {
        return isset($this->CollectorNodeExchangeName) ? $this->CollectorNodeExchangeName : null;
    }
    /**
     * Set CollectorNodeExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectorNodeExchangeName
     * @return \StructType\EDFAAvailability
     */
    public function setCollectorNodeExchangeName($collectorNodeExchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($collectorNodeExchangeName) && !is_string($collectorNodeExchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectorNodeExchangeName)), __LINE__);
        }
        if (is_null($collectorNodeExchangeName) || (is_array($collectorNodeExchangeName) && empty($collectorNodeExchangeName))) {
            unset($this->CollectorNodeExchangeName);
        } else {
            $this->CollectorNodeExchangeName = $collectorNodeExchangeName;
        }
        return $this;
    }
    /**
     * Get Distance value
     * @return int|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\EDFAAvailability
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get EDFABandwidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getEDFABandwidth()
    {
        return isset($this->EDFABandwidth) ? $this->EDFABandwidth : null;
    }
    /**
     * Set EDFABandwidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $eDFABandwidth
     * @return \StructType\EDFAAvailability
     */
    public function setEDFABandwidth(\ArrayType\ArrayOfstring $eDFABandwidth = null)
    {
        if (is_null($eDFABandwidth) || (is_array($eDFABandwidth) && empty($eDFABandwidth))) {
            unset($this->EDFABandwidth);
        } else {
            $this->EDFABandwidth = $eDFABandwidth;
        }
        return $this;
    }
    /**
     * Get EDFASubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEDFASubType()
    {
        return isset($this->EDFASubType) ? $this->EDFASubType : null;
    }
    /**
     * Set EDFASubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eDFASubType
     * @return \StructType\EDFAAvailability
     */
    public function setEDFASubType($eDFASubType = null)
    {
        // validation for constraint: string
        if (!is_null($eDFASubType) && !is_string($eDFASubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eDFASubType)), __LINE__);
        }
        if (is_null($eDFASubType) || (is_array($eDFASubType) && empty($eDFASubType))) {
            unset($this->EDFASubType);
        } else {
            $this->EDFASubType = $eDFASubType;
        }
        return $this;
    }
    /**
     * Get FibreExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFibreExchangeCode()
    {
        return isset($this->FibreExchangeCode) ? $this->FibreExchangeCode : null;
    }
    /**
     * Set FibreExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fibreExchangeCode
     * @return \StructType\EDFAAvailability
     */
    public function setFibreExchangeCode($fibreExchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($fibreExchangeCode) && !is_string($fibreExchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fibreExchangeCode)), __LINE__);
        }
        if (is_null($fibreExchangeCode) || (is_array($fibreExchangeCode) && empty($fibreExchangeCode))) {
            unset($this->FibreExchangeCode);
        } else {
            $this->FibreExchangeCode = $fibreExchangeCode;
        }
        return $this;
    }
    /**
     * Get FibreExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFibreExchangeName()
    {
        return isset($this->FibreExchangeName) ? $this->FibreExchangeName : null;
    }
    /**
     * Set FibreExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fibreExchangeName
     * @return \StructType\EDFAAvailability
     */
    public function setFibreExchangeName($fibreExchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($fibreExchangeName) && !is_string($fibreExchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fibreExchangeName)), __LINE__);
        }
        if (is_null($fibreExchangeName) || (is_array($fibreExchangeName) && empty($fibreExchangeName))) {
            unset($this->FibreExchangeName);
        } else {
            $this->FibreExchangeName = $fibreExchangeName;
        }
        return $this;
    }
    /**
     * Get IndicativeECC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndicativeECC()
    {
        return isset($this->IndicativeECC) ? $this->IndicativeECC : null;
    }
    /**
     * Set IndicativeECC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indicativeECC
     * @return \StructType\EDFAAvailability
     */
    public function setIndicativeECC($indicativeECC = null)
    {
        // validation for constraint: string
        if (!is_null($indicativeECC) && !is_string($indicativeECC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indicativeECC)), __LINE__);
        }
        if (is_null($indicativeECC) || (is_array($indicativeECC) && empty($indicativeECC))) {
            unset($this->IndicativeECC);
        } else {
            $this->IndicativeECC = $indicativeECC;
        }
        return $this;
    }
    /**
     * Get IndicativeOrderCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndicativeOrderCategory()
    {
        return isset($this->IndicativeOrderCategory) ? $this->IndicativeOrderCategory : null;
    }
    /**
     * Set IndicativeOrderCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indicativeOrderCategory
     * @return \StructType\EDFAAvailability
     */
    public function setIndicativeOrderCategory($indicativeOrderCategory = null)
    {
        // validation for constraint: string
        if (!is_null($indicativeOrderCategory) && !is_string($indicativeOrderCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indicativeOrderCategory)), __LINE__);
        }
        if (is_null($indicativeOrderCategory) || (is_array($indicativeOrderCategory) && empty($indicativeOrderCategory))) {
            unset($this->IndicativeOrderCategory);
        } else {
            $this->IndicativeOrderCategory = $indicativeOrderCategory;
        }
        return $this;
    }
    /**
     * Get LocalExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalExchangeCode()
    {
        return isset($this->LocalExchangeCode) ? $this->LocalExchangeCode : null;
    }
    /**
     * Set LocalExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localExchangeCode
     * @return \StructType\EDFAAvailability
     */
    public function setLocalExchangeCode($localExchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($localExchangeCode) && !is_string($localExchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localExchangeCode)), __LINE__);
        }
        if (is_null($localExchangeCode) || (is_array($localExchangeCode) && empty($localExchangeCode))) {
            unset($this->LocalExchangeCode);
        } else {
            $this->LocalExchangeCode = $localExchangeCode;
        }
        return $this;
    }
    /**
     * Get LocalExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalExchangeName()
    {
        return isset($this->LocalExchangeName) ? $this->LocalExchangeName : null;
    }
    /**
     * Set LocalExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localExchangeName
     * @return \StructType\EDFAAvailability
     */
    public function setLocalExchangeName($localExchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($localExchangeName) && !is_string($localExchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localExchangeName)), __LINE__);
        }
        if (is_null($localExchangeName) || (is_array($localExchangeName) && empty($localExchangeName))) {
            unset($this->LocalExchangeName);
        } else {
            $this->LocalExchangeName = $localExchangeName;
        }
        return $this;
    }
    /**
     * Get ORLeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getORLeadTime()
    {
        return isset($this->ORLeadTime) ? $this->ORLeadTime : null;
    }
    /**
     * Set ORLeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oRLeadTime
     * @return \StructType\EDFAAvailability
     */
    public function setORLeadTime($oRLeadTime = null)
    {
        // validation for constraint: string
        if (!is_null($oRLeadTime) && !is_string($oRLeadTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oRLeadTime)), __LINE__);
        }
        if (is_null($oRLeadTime) || (is_array($oRLeadTime) && empty($oRLeadTime))) {
            unset($this->ORLeadTime);
        } else {
            $this->ORLeadTime = $oRLeadTime;
        }
        return $this;
    }
    /**
     * Get OrderCategoryExplanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderCategoryExplanation()
    {
        return isset($this->OrderCategoryExplanation) ? $this->OrderCategoryExplanation : null;
    }
    /**
     * Set OrderCategoryExplanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderCategoryExplanation
     * @return \StructType\EDFAAvailability
     */
    public function setOrderCategoryExplanation($orderCategoryExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($orderCategoryExplanation) && !is_string($orderCategoryExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderCategoryExplanation)), __LINE__);
        }
        if (is_null($orderCategoryExplanation) || (is_array($orderCategoryExplanation) && empty($orderCategoryExplanation))) {
            unset($this->OrderCategoryExplanation);
        } else {
            $this->OrderCategoryExplanation = $orderCategoryExplanation;
        }
        return $this;
    }
    /**
     * Get ResilienceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReslilienceInformationResult|null
     */
    public function getResilienceInformation()
    {
        return isset($this->ResilienceInformation) ? $this->ResilienceInformation : null;
    }
    /**
     * Set ResilienceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @return \StructType\EDFAAvailability
     */
    public function setResilienceInformation(\StructType\ReslilienceInformationResult $resilienceInformation = null)
    {
        if (is_null($resilienceInformation) || (is_array($resilienceInformation) && empty($resilienceInformation))) {
            unset($this->ResilienceInformation);
        } else {
            $this->ResilienceInformation = $resilienceInformation;
        }
        return $this;
    }
    /**
     * Get TTLeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTTLeadTime()
    {
        return isset($this->TTLeadTime) ? $this->TTLeadTime : null;
    }
    /**
     * Set TTLeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tTLeadTime
     * @return \StructType\EDFAAvailability
     */
    public function setTTLeadTime($tTLeadTime = null)
    {
        // validation for constraint: string
        if (!is_null($tTLeadTime) && !is_string($tTLeadTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tTLeadTime)), __LINE__);
        }
        if (is_null($tTLeadTime) || (is_array($tTLeadTime) && empty($tTLeadTime))) {
            unset($this->TTLeadTime);
        } else {
            $this->TTLeadTime = $tTLeadTime;
        }
        return $this;
    }
    /**
     * Get Zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZone()
    {
        return isset($this->Zone) ? $this->Zone : null;
    }
    /**
     * Set Zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zone
     * @return \StructType\EDFAAvailability
     */
    public function setZone($zone = null)
    {
        // validation for constraint: string
        if (!is_null($zone) && !is_string($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zone)), __LINE__);
        }
        if (is_null($zone) || (is_array($zone) && empty($zone))) {
            unset($this->Zone);
        } else {
            $this->Zone = $zone;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EDFAAvailability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
