<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EADAvailabilityResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EADAvailabilityResult
 * @subpackage Structs
 */
class EADAvailabilityResult extends AbstractStructBase
{
    /**
     * The CollectorNodeExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectorNodeExchangeCode;
    /**
     * The CollectorNodeExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectorNodeExchangeName;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Distance;
    /**
     * The EADBandwidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $EADBandwidth;
    /**
     * The EADSubType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EADSubType;
    /**
     * The FibreExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FibreExchangeCode;
    /**
     * The FibreExchangename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FibreExchangename;
    /**
     * The IndicativeECC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndicativeECC;
    /**
     * The IndicativeOrderCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndicativeOrderCategory;
    /**
     * The LocalExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalExchangeCode;
    /**
     * The LocalExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalExchangeName;
    /**
     * The ORLeadTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ORLeadTime;
    /**
     * The OrderCategoryExplanation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderCategoryExplanation;
    /**
     * The ResilienceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReslilienceInformationResult
     */
    public $ResilienceInformation;
    /**
     * The TTLeadTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TTLeadTime;
    /**
     * The Zone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zone;
    /**
     * Constructor method for EADAvailabilityResult
     * @uses EADAvailabilityResult::setCollectorNodeExchangeCode()
     * @uses EADAvailabilityResult::setCollectorNodeExchangeName()
     * @uses EADAvailabilityResult::setDistance()
     * @uses EADAvailabilityResult::setEADBandwidth()
     * @uses EADAvailabilityResult::setEADSubType()
     * @uses EADAvailabilityResult::setFibreExchangeCode()
     * @uses EADAvailabilityResult::setFibreExchangename()
     * @uses EADAvailabilityResult::setIndicativeECC()
     * @uses EADAvailabilityResult::setIndicativeOrderCategory()
     * @uses EADAvailabilityResult::setLocalExchangeCode()
     * @uses EADAvailabilityResult::setLocalExchangeName()
     * @uses EADAvailabilityResult::setORLeadTime()
     * @uses EADAvailabilityResult::setOrderCategoryExplanation()
     * @uses EADAvailabilityResult::setResilienceInformation()
     * @uses EADAvailabilityResult::setTTLeadTime()
     * @uses EADAvailabilityResult::setZone()
     * @param string $collectorNodeExchangeCode
     * @param string $collectorNodeExchangeName
     * @param int $distance
     * @param \ArrayType\ArrayOfstring $eADBandwidth
     * @param string $eADSubType
     * @param string $fibreExchangeCode
     * @param string $fibreExchangename
     * @param string $indicativeECC
     * @param string $indicativeOrderCategory
     * @param string $localExchangeCode
     * @param string $localExchangeName
     * @param string $oRLeadTime
     * @param string $orderCategoryExplanation
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @param string $tTLeadTime
     * @param string $zone
     */
    public function __construct($collectorNodeExchangeCode = null, $collectorNodeExchangeName = null, $distance = null, \ArrayType\ArrayOfstring $eADBandwidth = null, $eADSubType = null, $fibreExchangeCode = null, $fibreExchangename = null, $indicativeECC = null, $indicativeOrderCategory = null, $localExchangeCode = null, $localExchangeName = null, $oRLeadTime = null, $orderCategoryExplanation = null, \StructType\ReslilienceInformationResult $resilienceInformation = null, $tTLeadTime = null, $zone = null)
    {
        $this
            ->setCollectorNodeExchangeCode($collectorNodeExchangeCode)
            ->setCollectorNodeExchangeName($collectorNodeExchangeName)
            ->setDistance($distance)
            ->setEADBandwidth($eADBandwidth)
            ->setEADSubType($eADSubType)
            ->setFibreExchangeCode($fibreExchangeCode)
            ->setFibreExchangename($fibreExchangename)
            ->setIndicativeECC($indicativeECC)
            ->setIndicativeOrderCategory($indicativeOrderCategory)
            ->setLocalExchangeCode($localExchangeCode)
            ->setLocalExchangeName($localExchangeName)
            ->setORLeadTime($oRLeadTime)
            ->setOrderCategoryExplanation($orderCategoryExplanation)
            ->setResilienceInformation($resilienceInformation)
            ->setTTLeadTime($tTLeadTime)
            ->setZone($zone);
    }
    /**
     * Get CollectorNodeExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectorNodeExchangeCode()
    {
        return isset($this->CollectorNodeExchangeCode) ? $this->CollectorNodeExchangeCode : null;
    }
    /**
     * Set CollectorNodeExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectorNodeExchangeCode
     * @return \StructType\EADAvailabilityResult
     */
    public function setCollectorNodeExchangeCode($collectorNodeExchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($collectorNodeExchangeCode) && !is_string($collectorNodeExchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectorNodeExchangeCode)), __LINE__);
        }
        if (is_null($collectorNodeExchangeCode) || (is_array($collectorNodeExchangeCode) && empty($collectorNodeExchangeCode))) {
            unset($this->CollectorNodeExchangeCode);
        } else {
            $this->CollectorNodeExchangeCode = $collectorNodeExchangeCode;
        }
        return $this;
    }
    /**
     * Get CollectorNodeExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectorNodeExchangeName()
    {
        return isset($this->CollectorNodeExchangeName) ? $this->CollectorNodeExchangeName : null;
    }
    /**
     * Set CollectorNodeExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectorNodeExchangeName
     * @return \StructType\EADAvailabilityResult
     */
    public function setCollectorNodeExchangeName($collectorNodeExchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($collectorNodeExchangeName) && !is_string($collectorNodeExchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectorNodeExchangeName)), __LINE__);
        }
        if (is_null($collectorNodeExchangeName) || (is_array($collectorNodeExchangeName) && empty($collectorNodeExchangeName))) {
            unset($this->CollectorNodeExchangeName);
        } else {
            $this->CollectorNodeExchangeName = $collectorNodeExchangeName;
        }
        return $this;
    }
    /**
     * Get Distance value
     * @return int|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\EADAvailabilityResult
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get EADBandwidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getEADBandwidth()
    {
        return isset($this->EADBandwidth) ? $this->EADBandwidth : null;
    }
    /**
     * Set EADBandwidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $eADBandwidth
     * @return \StructType\EADAvailabilityResult
     */
    public function setEADBandwidth(\ArrayType\ArrayOfstring $eADBandwidth = null)
    {
        if (is_null($eADBandwidth) || (is_array($eADBandwidth) && empty($eADBandwidth))) {
            unset($this->EADBandwidth);
        } else {
            $this->EADBandwidth = $eADBandwidth;
        }
        return $this;
    }
    /**
     * Get EADSubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEADSubType()
    {
        return isset($this->EADSubType) ? $this->EADSubType : null;
    }
    /**
     * Set EADSubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eADSubType
     * @return \StructType\EADAvailabilityResult
     */
    public function setEADSubType($eADSubType = null)
    {
        // validation for constraint: string
        if (!is_null($eADSubType) && !is_string($eADSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eADSubType)), __LINE__);
        }
        if (is_null($eADSubType) || (is_array($eADSubType) && empty($eADSubType))) {
            unset($this->EADSubType);
        } else {
            $this->EADSubType = $eADSubType;
        }
        return $this;
    }
    /**
     * Get FibreExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFibreExchangeCode()
    {
        return isset($this->FibreExchangeCode) ? $this->FibreExchangeCode : null;
    }
    /**
     * Set FibreExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fibreExchangeCode
     * @return \StructType\EADAvailabilityResult
     */
    public function setFibreExchangeCode($fibreExchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($fibreExchangeCode) && !is_string($fibreExchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fibreExchangeCode)), __LINE__);
        }
        if (is_null($fibreExchangeCode) || (is_array($fibreExchangeCode) && empty($fibreExchangeCode))) {
            unset($this->FibreExchangeCode);
        } else {
            $this->FibreExchangeCode = $fibreExchangeCode;
        }
        return $this;
    }
    /**
     * Get FibreExchangename value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFibreExchangename()
    {
        return isset($this->FibreExchangename) ? $this->FibreExchangename : null;
    }
    /**
     * Set FibreExchangename value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fibreExchangename
     * @return \StructType\EADAvailabilityResult
     */
    public function setFibreExchangename($fibreExchangename = null)
    {
        // validation for constraint: string
        if (!is_null($fibreExchangename) && !is_string($fibreExchangename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fibreExchangename)), __LINE__);
        }
        if (is_null($fibreExchangename) || (is_array($fibreExchangename) && empty($fibreExchangename))) {
            unset($this->FibreExchangename);
        } else {
            $this->FibreExchangename = $fibreExchangename;
        }
        return $this;
    }
    /**
     * Get IndicativeECC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndicativeECC()
    {
        return isset($this->IndicativeECC) ? $this->IndicativeECC : null;
    }
    /**
     * Set IndicativeECC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indicativeECC
     * @return \StructType\EADAvailabilityResult
     */
    public function setIndicativeECC($indicativeECC = null)
    {
        // validation for constraint: string
        if (!is_null($indicativeECC) && !is_string($indicativeECC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indicativeECC)), __LINE__);
        }
        if (is_null($indicativeECC) || (is_array($indicativeECC) && empty($indicativeECC))) {
            unset($this->IndicativeECC);
        } else {
            $this->IndicativeECC = $indicativeECC;
        }
        return $this;
    }
    /**
     * Get IndicativeOrderCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndicativeOrderCategory()
    {
        return isset($this->IndicativeOrderCategory) ? $this->IndicativeOrderCategory : null;
    }
    /**
     * Set IndicativeOrderCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indicativeOrderCategory
     * @return \StructType\EADAvailabilityResult
     */
    public function setIndicativeOrderCategory($indicativeOrderCategory = null)
    {
        // validation for constraint: string
        if (!is_null($indicativeOrderCategory) && !is_string($indicativeOrderCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indicativeOrderCategory)), __LINE__);
        }
        if (is_null($indicativeOrderCategory) || (is_array($indicativeOrderCategory) && empty($indicativeOrderCategory))) {
            unset($this->IndicativeOrderCategory);
        } else {
            $this->IndicativeOrderCategory = $indicativeOrderCategory;
        }
        return $this;
    }
    /**
     * Get LocalExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalExchangeCode()
    {
        return isset($this->LocalExchangeCode) ? $this->LocalExchangeCode : null;
    }
    /**
     * Set LocalExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localExchangeCode
     * @return \StructType\EADAvailabilityResult
     */
    public function setLocalExchangeCode($localExchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($localExchangeCode) && !is_string($localExchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localExchangeCode)), __LINE__);
        }
        if (is_null($localExchangeCode) || (is_array($localExchangeCode) && empty($localExchangeCode))) {
            unset($this->LocalExchangeCode);
        } else {
            $this->LocalExchangeCode = $localExchangeCode;
        }
        return $this;
    }
    /**
     * Get LocalExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalExchangeName()
    {
        return isset($this->LocalExchangeName) ? $this->LocalExchangeName : null;
    }
    /**
     * Set LocalExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localExchangeName
     * @return \StructType\EADAvailabilityResult
     */
    public function setLocalExchangeName($localExchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($localExchangeName) && !is_string($localExchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localExchangeName)), __LINE__);
        }
        if (is_null($localExchangeName) || (is_array($localExchangeName) && empty($localExchangeName))) {
            unset($this->LocalExchangeName);
        } else {
            $this->LocalExchangeName = $localExchangeName;
        }
        return $this;
    }
    /**
     * Get ORLeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getORLeadTime()
    {
        return isset($this->ORLeadTime) ? $this->ORLeadTime : null;
    }
    /**
     * Set ORLeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oRLeadTime
     * @return \StructType\EADAvailabilityResult
     */
    public function setORLeadTime($oRLeadTime = null)
    {
        // validation for constraint: string
        if (!is_null($oRLeadTime) && !is_string($oRLeadTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oRLeadTime)), __LINE__);
        }
        if (is_null($oRLeadTime) || (is_array($oRLeadTime) && empty($oRLeadTime))) {
            unset($this->ORLeadTime);
        } else {
            $this->ORLeadTime = $oRLeadTime;
        }
        return $this;
    }
    /**
     * Get OrderCategoryExplanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderCategoryExplanation()
    {
        return isset($this->OrderCategoryExplanation) ? $this->OrderCategoryExplanation : null;
    }
    /**
     * Set OrderCategoryExplanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderCategoryExplanation
     * @return \StructType\EADAvailabilityResult
     */
    public function setOrderCategoryExplanation($orderCategoryExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($orderCategoryExplanation) && !is_string($orderCategoryExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderCategoryExplanation)), __LINE__);
        }
        if (is_null($orderCategoryExplanation) || (is_array($orderCategoryExplanation) && empty($orderCategoryExplanation))) {
            unset($this->OrderCategoryExplanation);
        } else {
            $this->OrderCategoryExplanation = $orderCategoryExplanation;
        }
        return $this;
    }
    /**
     * Get ResilienceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReslilienceInformationResult|null
     */
    public function getResilienceInformation()
    {
        return isset($this->ResilienceInformation) ? $this->ResilienceInformation : null;
    }
    /**
     * Set ResilienceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @return \StructType\EADAvailabilityResult
     */
    public function setResilienceInformation(\StructType\ReslilienceInformationResult $resilienceInformation = null)
    {
        if (is_null($resilienceInformation) || (is_array($resilienceInformation) && empty($resilienceInformation))) {
            unset($this->ResilienceInformation);
        } else {
            $this->ResilienceInformation = $resilienceInformation;
        }
        return $this;
    }
    /**
     * Get TTLeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTTLeadTime()
    {
        return isset($this->TTLeadTime) ? $this->TTLeadTime : null;
    }
    /**
     * Set TTLeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tTLeadTime
     * @return \StructType\EADAvailabilityResult
     */
    public function setTTLeadTime($tTLeadTime = null)
    {
        // validation for constraint: string
        if (!is_null($tTLeadTime) && !is_string($tTLeadTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tTLeadTime)), __LINE__);
        }
        if (is_null($tTLeadTime) || (is_array($tTLeadTime) && empty($tTLeadTime))) {
            unset($this->TTLeadTime);
        } else {
            $this->TTLeadTime = $tTLeadTime;
        }
        return $this;
    }
    /**
     * Get Zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZone()
    {
        return isset($this->Zone) ? $this->Zone : null;
    }
    /**
     * Set Zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zone
     * @return \StructType\EADAvailabilityResult
     */
    public function setZone($zone = null)
    {
        // validation for constraint: string
        if (!is_null($zone) && !is_string($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zone)), __LINE__);
        }
        if (is_null($zone) || (is_array($zone) && empty($zone))) {
            unset($this->Zone);
        } else {
            $this->Zone = $zone;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EADAvailabilityResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
