<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EADAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EADAvailabilityDetails
 * @subpackage Structs
 */
class EADAvailabilityDetails extends AvailabilityDetails
{
    /**
     * The EADAvailability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEADAvailabilityResult
     */
    public $EADAvailability;
    /**
     * The LeadTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LeadTime;
    /**
     * The PostCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostCode;
    /**
     * Constructor method for EADAvailabilityDetails
     * @uses EADAvailabilityDetails::setEADAvailability()
     * @uses EADAvailabilityDetails::setLeadTime()
     * @uses EADAvailabilityDetails::setPostCode()
     * @param \ArrayType\ArrayOfEADAvailabilityResult $eADAvailability
     * @param int $leadTime
     * @param string $postCode
     */
    public function __construct(\ArrayType\ArrayOfEADAvailabilityResult $eADAvailability = null, $leadTime = null, $postCode = null)
    {
        $this
            ->setEADAvailability($eADAvailability)
            ->setLeadTime($leadTime)
            ->setPostCode($postCode);
    }
    /**
     * Get EADAvailability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEADAvailabilityResult|null
     */
    public function getEADAvailability()
    {
        return isset($this->EADAvailability) ? $this->EADAvailability : null;
    }
    /**
     * Set EADAvailability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEADAvailabilityResult $eADAvailability
     * @return \StructType\EADAvailabilityDetails
     */
    public function setEADAvailability(\ArrayType\ArrayOfEADAvailabilityResult $eADAvailability = null)
    {
        if (is_null($eADAvailability) || (is_array($eADAvailability) && empty($eADAvailability))) {
            unset($this->EADAvailability);
        } else {
            $this->EADAvailability = $eADAvailability;
        }
        return $this;
    }
    /**
     * Get LeadTime value
     * @return int|null
     */
    public function getLeadTime()
    {
        return $this->LeadTime;
    }
    /**
     * Set LeadTime value
     * @param int $leadTime
     * @return \StructType\EADAvailabilityDetails
     */
    public function setLeadTime($leadTime = null)
    {
        // validation for constraint: int
        if (!is_null($leadTime) && !is_numeric($leadTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($leadTime)), __LINE__);
        }
        $this->LeadTime = $leadTime;
        return $this;
    }
    /**
     * Get PostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostCode()
    {
        return isset($this->PostCode) ? $this->PostCode : null;
    }
    /**
     * Set PostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postCode
     * @return \StructType\EADAvailabilityDetails
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        if (is_null($postCode) || (is_array($postCode) && empty($postCode))) {
            unset($this->PostCode);
        } else {
            $this->PostCode = $postCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EADAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
