<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DSLSpeedInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DSLSpeedInformation
 * @subpackage Structs
 */
class DSLSpeedInformation extends AbstractStructBase
{
    /**
     * The AttainableCurrentDownstreamSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttainableCurrentDownstreamSpeed;
    /**
     * The AttainableCurrentUpstreamSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttainableCurrentUpstreamSpeed;
    /**
     * The CurrentDSLType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DSLType
     */
    public $CurrentDSLType;
    /**
     * The CurrentDownstreamSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentDownstreamSpeed;
    /**
     * The CurrentServiceCapped
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentServiceCapped;
    /**
     * The CurrentUpstreamSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentUpstreamSpeed;
    /**
     * Constructor method for DSLSpeedInformation
     * @uses DSLSpeedInformation::setAttainableCurrentDownstreamSpeed()
     * @uses DSLSpeedInformation::setAttainableCurrentUpstreamSpeed()
     * @uses DSLSpeedInformation::setCurrentDSLType()
     * @uses DSLSpeedInformation::setCurrentDownstreamSpeed()
     * @uses DSLSpeedInformation::setCurrentServiceCapped()
     * @uses DSLSpeedInformation::setCurrentUpstreamSpeed()
     * @param string $attainableCurrentDownstreamSpeed
     * @param string $attainableCurrentUpstreamSpeed
     * @param \StructType\DSLType $currentDSLType
     * @param string $currentDownstreamSpeed
     * @param string $currentServiceCapped
     * @param string $currentUpstreamSpeed
     */
    public function __construct($attainableCurrentDownstreamSpeed = null, $attainableCurrentUpstreamSpeed = null, \StructType\DSLType $currentDSLType = null, $currentDownstreamSpeed = null, $currentServiceCapped = null, $currentUpstreamSpeed = null)
    {
        $this
            ->setAttainableCurrentDownstreamSpeed($attainableCurrentDownstreamSpeed)
            ->setAttainableCurrentUpstreamSpeed($attainableCurrentUpstreamSpeed)
            ->setCurrentDSLType($currentDSLType)
            ->setCurrentDownstreamSpeed($currentDownstreamSpeed)
            ->setCurrentServiceCapped($currentServiceCapped)
            ->setCurrentUpstreamSpeed($currentUpstreamSpeed);
    }
    /**
     * Get AttainableCurrentDownstreamSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttainableCurrentDownstreamSpeed()
    {
        return isset($this->AttainableCurrentDownstreamSpeed) ? $this->AttainableCurrentDownstreamSpeed : null;
    }
    /**
     * Set AttainableCurrentDownstreamSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attainableCurrentDownstreamSpeed
     * @return \StructType\DSLSpeedInformation
     */
    public function setAttainableCurrentDownstreamSpeed($attainableCurrentDownstreamSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($attainableCurrentDownstreamSpeed) && !is_string($attainableCurrentDownstreamSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attainableCurrentDownstreamSpeed)), __LINE__);
        }
        if (is_null($attainableCurrentDownstreamSpeed) || (is_array($attainableCurrentDownstreamSpeed) && empty($attainableCurrentDownstreamSpeed))) {
            unset($this->AttainableCurrentDownstreamSpeed);
        } else {
            $this->AttainableCurrentDownstreamSpeed = $attainableCurrentDownstreamSpeed;
        }
        return $this;
    }
    /**
     * Get AttainableCurrentUpstreamSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttainableCurrentUpstreamSpeed()
    {
        return isset($this->AttainableCurrentUpstreamSpeed) ? $this->AttainableCurrentUpstreamSpeed : null;
    }
    /**
     * Set AttainableCurrentUpstreamSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attainableCurrentUpstreamSpeed
     * @return \StructType\DSLSpeedInformation
     */
    public function setAttainableCurrentUpstreamSpeed($attainableCurrentUpstreamSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($attainableCurrentUpstreamSpeed) && !is_string($attainableCurrentUpstreamSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attainableCurrentUpstreamSpeed)), __LINE__);
        }
        if (is_null($attainableCurrentUpstreamSpeed) || (is_array($attainableCurrentUpstreamSpeed) && empty($attainableCurrentUpstreamSpeed))) {
            unset($this->AttainableCurrentUpstreamSpeed);
        } else {
            $this->AttainableCurrentUpstreamSpeed = $attainableCurrentUpstreamSpeed;
        }
        return $this;
    }
    /**
     * Get CurrentDSLType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DSLType|null
     */
    public function getCurrentDSLType()
    {
        return isset($this->CurrentDSLType) ? $this->CurrentDSLType : null;
    }
    /**
     * Set CurrentDSLType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DSLType $currentDSLType
     * @return \StructType\DSLSpeedInformation
     */
    public function setCurrentDSLType(\StructType\DSLType $currentDSLType = null)
    {
        if (is_null($currentDSLType) || (is_array($currentDSLType) && empty($currentDSLType))) {
            unset($this->CurrentDSLType);
        } else {
            $this->CurrentDSLType = $currentDSLType;
        }
        return $this;
    }
    /**
     * Get CurrentDownstreamSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentDownstreamSpeed()
    {
        return isset($this->CurrentDownstreamSpeed) ? $this->CurrentDownstreamSpeed : null;
    }
    /**
     * Set CurrentDownstreamSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentDownstreamSpeed
     * @return \StructType\DSLSpeedInformation
     */
    public function setCurrentDownstreamSpeed($currentDownstreamSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($currentDownstreamSpeed) && !is_string($currentDownstreamSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentDownstreamSpeed)), __LINE__);
        }
        if (is_null($currentDownstreamSpeed) || (is_array($currentDownstreamSpeed) && empty($currentDownstreamSpeed))) {
            unset($this->CurrentDownstreamSpeed);
        } else {
            $this->CurrentDownstreamSpeed = $currentDownstreamSpeed;
        }
        return $this;
    }
    /**
     * Get CurrentServiceCapped value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentServiceCapped()
    {
        return isset($this->CurrentServiceCapped) ? $this->CurrentServiceCapped : null;
    }
    /**
     * Set CurrentServiceCapped value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentServiceCapped
     * @return \StructType\DSLSpeedInformation
     */
    public function setCurrentServiceCapped($currentServiceCapped = null)
    {
        // validation for constraint: string
        if (!is_null($currentServiceCapped) && !is_string($currentServiceCapped)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentServiceCapped)), __LINE__);
        }
        if (is_null($currentServiceCapped) || (is_array($currentServiceCapped) && empty($currentServiceCapped))) {
            unset($this->CurrentServiceCapped);
        } else {
            $this->CurrentServiceCapped = $currentServiceCapped;
        }
        return $this;
    }
    /**
     * Get CurrentUpstreamSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentUpstreamSpeed()
    {
        return isset($this->CurrentUpstreamSpeed) ? $this->CurrentUpstreamSpeed : null;
    }
    /**
     * Set CurrentUpstreamSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentUpstreamSpeed
     * @return \StructType\DSLSpeedInformation
     */
    public function setCurrentUpstreamSpeed($currentUpstreamSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($currentUpstreamSpeed) && !is_string($currentUpstreamSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentUpstreamSpeed)), __LINE__);
        }
        if (is_null($currentUpstreamSpeed) || (is_array($currentUpstreamSpeed) && empty($currentUpstreamSpeed))) {
            unset($this->CurrentUpstreamSpeed);
        } else {
            $this->CurrentUpstreamSpeed = $currentUpstreamSpeed;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DSLSpeedInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
